/** @jsx jsx */

import { css, jsx } from '@emotion/react';

// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize as getGridSize } from '@atlaskit/theme/constants';
const gridSize = getGridSize();
const verticalMarginSize = "var(--ds-space-600, 48px)";
const columnWidth = gridSize * 8;
const gutter = gridSize * 2;
const containerStyles = css({
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  margin: `${verticalMarginSize} auto`,
  textAlign: 'center'
});

/* Use max-width so the component can shrink on smaller viewports. */
const wideContainerStyles = css({
  maxWidth: `${columnWidth * 6 + gutter * 5}px`
});
const narrowContainerStyles = css({
  maxWidth: `${columnWidth * 4 + gutter * 3}px`
});
/**
 * __Container__
 *
 * Upper level container for Empty State.
 *
 * @internal
 */
const Container = ({
  children,
  width,
  testId
}) => jsx("div", {
  "data-testid": testId,
  css: [containerStyles, width === 'narrow' ? narrowContainerStyles : wideContainerStyles]
}, children);
export default Container;