/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { N800 } from '@atlaskit/theme/colors';
const descriptionStyles = css({
  marginTop: "var(--ds-space-0, 0px)",
  marginBottom: "var(--ds-space-300, 24px)",
  color: `var(--ds-text, ${N800})`
});

/**
 * __Description__
 *
 * Description of Empty State.
 *
 * @internal
 */
const Description = ({
  children
}) => jsx("p", {
  css: descriptionStyles
}, children);
export default Description;