/** @jsx jsx */

import { css, jsx } from '@emotion/react';
const CSS_VAR_MAX_WIDTH = '--max-width';
const CSS_VAR_MAX_HEIGHT = '--max-height';
const imageStyles = css({
  display: 'block',
  maxWidth: `var(${CSS_VAR_MAX_WIDTH})`,
  maxHeight: `var(${CSS_VAR_MAX_HEIGHT})`,
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  margin: `0 auto ${"var(--ds-space-300, 24px)"}`
});

/**
 * __Image__
 *
 * Image in Empty State.
 *
 * @internal
 */
const Image = ({
  maxHeight,
  maxWidth,
  height = 'auto',
  width = 'auto',
  src
}) => jsx("img", {
  style: {
    [CSS_VAR_MAX_WIDTH]: `${maxWidth}px`,
    [CSS_VAR_MAX_HEIGHT]: `${maxHeight}px`
  },
  width: width,
  height: height,
  alt: "",
  role: "presentation",
  css: imageStyles,
  src: src
});
export default Image;