/** @jsx jsx */

import { css, jsx } from '@emotion/react';
const spinnerContainerStyles = css({
  width: "var(--ds-space-300, 24px)",
  marginLeft: "var(--ds-space-200, 16px)"
});

/**
 * __Spinner container__
 *
 * A spinner container for loading state of Empty State.
 *
 * @internal
 */
const SpinnerContainer = ({
  children
}) => jsx("div", {
  css: spinnerContainerStyles
}, children);
export default SpinnerContainer;