import React from 'react';
import ButtonGroup from '@atlaskit/button/button-group';
import Spinner from '@atlaskit/spinner';
import { ActionsContainer, Container, Description, Header, Image as HeaderImage, SpinnerContainer } from './styled';
/**
 * __Empty state__
 *
 * A component used for presenting various empty states.
 * e.g. (no items, empty search, broken link, welcome screen etc.)
 *
 * @example
 * ```tsx
 * import EmptyState from '@atlaskit/empty-state';
 *
 * // An example of a 404 state
 * export default () => {
 *  <EmptyState
 *   header="Page not found"
 *   imageUrl="https://cdn.io/images/404"
 *   description="Looks like you've stumbled off track. Sorry about that! This page either doesn't exist or has been removed."
 *   primaryAction={<Button appearance="primary">Home Page</Button>}
 *   secondaryAction={<Button>Report a problem</Button>}
 *  />;
 * };
 * ```
 */
var EmptyState = function EmptyState(_ref) {
  var description = _ref.description,
    header = _ref.header,
    _ref$headingLevel = _ref.headingLevel,
    headingLevel = _ref$headingLevel === void 0 ? 4 : _ref$headingLevel,
    imageHeight = _ref.imageHeight,
    imageUrl = _ref.imageUrl,
    imageWidth = _ref.imageWidth,
    isLoading = _ref.isLoading,
    _ref$maxImageHeight = _ref.maxImageHeight,
    maxImageHeight = _ref$maxImageHeight === void 0 ? 160 : _ref$maxImageHeight,
    _ref$maxImageWidth = _ref.maxImageWidth,
    maxImageWidth = _ref$maxImageWidth === void 0 ? 160 : _ref$maxImageWidth,
    primaryAction = _ref.primaryAction,
    renderImage = _ref.renderImage,
    secondaryAction = _ref.secondaryAction,
    width = _ref.width,
    size = _ref.size,
    tertiaryAction = _ref.tertiaryAction,
    testId = _ref.testId;
  var actionsContainer = primaryAction || secondaryAction || isLoading ? /*#__PURE__*/React.createElement(ActionsContainer, null, /*#__PURE__*/React.createElement(ButtonGroup, null, secondaryAction, primaryAction), /*#__PURE__*/React.createElement(SpinnerContainer, null, isLoading && /*#__PURE__*/React.createElement(Spinner, {
    testId: "empty-state-spinner"
  }))) : null;
  return /*#__PURE__*/React.createElement(Container, {
    testId: testId,
    width: width || size || 'wide'
  }, imageUrl ? /*#__PURE__*/React.createElement(HeaderImage, {
    src: imageUrl,
    maxWidth: maxImageWidth,
    maxHeight: maxImageHeight,
    width: imageWidth,
    height: imageHeight
  }) : renderImage && renderImage({
    maxImageWidth: maxImageWidth,
    maxImageHeight: maxImageHeight,
    imageWidth: imageWidth,
    imageHeight: imageHeight
  }), /*#__PURE__*/React.createElement(Header, {
    level: headingLevel
  }, header), description && /*#__PURE__*/React.createElement(Description, null, description), actionsContainer, tertiaryAction);
};
export default EmptyState;