/// <reference types="react" />
import type { EmptyStateProps } from './types';
/**
 * __Empty state__
 *
 * A component used for presenting various empty states.
 * e.g. (no items, empty search, broken link, welcome screen etc.)
 *
 * @example
 * ```tsx
 * import EmptyState from '@atlaskit/empty-state';
 *
 * // An example of a 404 state
 * export default () => {
 *  <EmptyState
 *   header="Page not found"
 *   imageUrl="https://cdn.io/images/404"
 *   description="Looks like you've stumbled off track. Sorry about that! This page either doesn't exist or has been removed."
 *   primaryAction={<Button appearance="primary">Home Page</Button>}
 *   secondaryAction={<Button>Report a problem</Button>}
 *  />;
 * };
 * ```
 */
declare const EmptyState: ({ description, header, headingLevel, imageHeight, imageUrl, imageWidth, isLoading, maxImageHeight, maxImageWidth, primaryAction, renderImage, secondaryAction, width, size, tertiaryAction, testId, }: EmptyStateProps) => JSX.Element;
export default EmptyState;
