"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _customThemeButton = _interopRequireDefault(require("@atlaskit/button/custom-theme-button"));
var _inline = _interopRequireDefault(require("@atlaskit/primitives/inline"));
var _constants = require("./constants");
var _theme = require("./theme");
/* eslint-disable @repo/internal/styles/no-nested-styles */
/** @jsx jsx */

var buttonStyles = (0, _react.css)({
  '&&, a&&': {
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    padding: "0 ".concat("var(--ds-space-100, 8px)", " !important"),
    background: "var(".concat(_constants.VAR_BG_COLOR, ")"),
    color: "var(".concat(_constants.VAR_COLOR, ") !important"),
    fontWeight: "var(--ds-font-weight-medium, 500)"
  },
  '&&:hover, &&:active, a&&:hover, a&&:active': {
    textDecoration: 'underline'
  },
  '&&:hover': {
    backgroundColor: "var(".concat(_constants.VAR_BG_COLOR_HOVER, ")")
  },
  '&&:active': {
    backgroundColor: "var(".concat(_constants.VAR_BG_COLOR_ACTIVE, ")")
  }
});
var appearanceNormalButtonStyles = (0, _react.css)({
  '&&, a&&': {
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    padding: '0 !important'
  }
});
var appearanceNormalActionsContainerStyles = (0, _react.css)({
  '&&, a&&': {
    transform: 'translateX(-2px)'
  }
});
var FlagActions = function FlagActions(props) {
  var _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? _constants.DEFAULT_APPEARANCE : _props$appearance,
    _props$actions = props.actions,
    actions = _props$actions === void 0 ? [] : _props$actions,
    linkComponent = props.linkComponent,
    testId = props.testId;
  if (!actions.length) {
    return null;
  }
  var isBold = appearance !== _constants.DEFAULT_APPEARANCE;
  return (0, _react.jsx)("span", {
    css: !isBold && appearanceNormalActionsContainerStyles
  }, (0, _react.jsx)(_inline.default, {
    space: "space.100",
    shouldWrap: true,
    alignBlock: "center",
    separator: isBold ? undefined : '·',
    testId: testId && "".concat(testId, "-actions")
  }, actions.map(function (action, index) {
    var _ref;
    return (0, _react.jsx)(_customThemeButton.default, {
      onClick: action.onClick,
      href: action.href,
      target: action.target,
      appearance: isBold ? 'default' : 'link',
      component: linkComponent,
      spacing: "compact",
      testId: action.testId,
      key: index,
      style: (_ref = {}, (0, _defineProperty2.default)(_ref, _constants.VAR_COLOR, _theme.actionTextColor[appearance]), (0, _defineProperty2.default)(_ref, _constants.VAR_BG_COLOR, _theme.actionBackgroundColor[appearance].default), (0, _defineProperty2.default)(_ref, _constants.VAR_BG_COLOR_HOVER, _theme.actionBackgroundColor[appearance].pressed), (0, _defineProperty2.default)(_ref, _constants.VAR_BG_COLOR_ACTIVE, _theme.actionBackgroundColor[appearance].active), _ref),
      css: [buttonStyles, appearance === _constants.DEFAULT_APPEARANCE && appearanceNormalButtonStyles]
    }, action.content);
  })));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var _default = FlagActions;
exports.default = _default;