"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlagsProvider = FlagsProvider;
exports.useFlags = useFlags;
exports.withFlagsProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _autoDismissFlag = _interopRequireDefault(require("./auto-dismiss-flag"));
var _flag = _interopRequireDefault(require("./flag"));
var _flagGroup = _interopRequireDefault(require("./flag-group"));
var _excluded = ["isAutoDismiss"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var FlagContext = /*#__PURE__*/_react.default.createContext(null);

/**
 * useFlags is used to access the `showFlags` function which can be used to programatically display flags.
 * - [Examples](https://atlassian.design/components/flag/flags-provider/examples#using-showflags)
 */
function useFlags() {
  var api = (0, _react.useContext)(FlagContext);
  if (api == null) {
    throw new Error('Unable to find FlagProviderContext');
  }
  return api;
}
var getUniqueId = function () {
  var count = 0;
  return function () {
    return "flag-provider-unique-id:".concat(count++);
  };
}();
function FlagsProvider(_ref) {
  var children = _ref.children;
  var _useState = (0, _react.useState)([]),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    flags = _useState2[0],
    setFlags = _useState2[1];
  var removeFlag = (0, _react.useCallback)(function (id) {
    setFlags(function (current) {
      return current.slice(0).filter(function (flag) {
        return flag.id !== id;
      });
    });
  }, []);
  var api = (0, _react.useMemo)(function () {
    return {
      showFlag: function show(value) {
        var flag = _objectSpread(_objectSpread({}, value), {}, {
          id: value.id || getUniqueId()
        });
        setFlags(function (current) {
          var index = current.findIndex(function (value) {
            return value.id === flag.id;
          });

          // If flag is not found add it
          if (index === -1) {
            return [flag].concat((0, _toConsumableArray2.default)(current));
          }

          // If flag already exists with the same id, then replace it
          var shallow = (0, _toConsumableArray2.default)(current);
          shallow[index] = flag;
          return shallow;
        });
        return function dismiss() {
          removeFlag(flag.id);
        };
      }
    };
  }, [removeFlag]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlagContext.Provider, {
    value: api
  }, children), /*#__PURE__*/_react.default.createElement(_flagGroup.default, {
    onDismissed: removeFlag
  }, flags.map(function (flag) {
    var isAutoDismiss = flag.isAutoDismiss,
      restProps = (0, _objectWithoutProperties2.default)(flag, _excluded);
    var FlagType = isAutoDismiss ? _autoDismissFlag.default : _flag.default;
    return /*#__PURE__*/_react.default.createElement(FlagType, (0, _extends2.default)({}, restProps, {
      key: flag.id
    }));
  })));
}
var withFlagsProvider = function withFlagsProvider(fn) {
  return /*#__PURE__*/_react.default.createElement(FlagsProvider, null, fn());
};
exports.withFlagsProvider = withFlagsProvider;