"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _focusRing = _interopRequireDefault(require("@atlaskit/focus-ring"));
var _chevronDown = _interopRequireDefault(require("@atlaskit/icon/glyph/hipchat/chevron-down"));
var _chevronUp = _interopRequireDefault(require("@atlaskit/icon/glyph/hipchat/chevron-up"));
var _cross = _interopRequireDefault(require("@atlaskit/icon/glyph/cross"));
var _theme = require("../theme");
/** @jsx jsx */

var buttonStyles = (0, _react2.css)({
  display: 'flex',
  width: '24px',
  height: '24px',
  padding: "var(--ds-space-0, 0px)",
  alignItems: 'center',
  justifyContent: 'center',
  flex: '0 0 auto',
  background: 'none',
  borderStyle: 'none',
  cursor: 'pointer',
  whiteSpace: 'nowrap'
});
var DismissButton = function DismissButton(_ref) {
  var appearance = _ref.appearance,
    onClick = _ref.onClick,
    isBold = _ref.isBold,
    isExpanded = _ref.isExpanded,
    testId = _ref.testId;
  var ButtonIcon = _cross.default;
  var buttonLabel = 'Dismiss';
  var size = 'small';
  var buttonTestId = testId && "".concat(testId, "-dismiss");
  if (isBold) {
    ButtonIcon = isExpanded ? _chevronUp.default : _chevronDown.default;
    buttonLabel = isExpanded ? 'Collapse' : 'Expand';
    size = 'medium';
    buttonTestId = testId && "".concat(testId, "-toggle");
  }
  return (0, _react2.jsx)(_focusRing.default, null, (0, _react2.jsx)("button", {
    type: "button",
    css: buttonStyles,
    onClick: onClick,
    "aria-expanded": isBold ? isExpanded : undefined,
    "data-testid": buttonTestId
  }, (0, _react2.jsx)(ButtonIcon, {
    label: buttonLabel,
    size: size,
    primaryColor: _theme.flagTextColorToken[appearance]
  })));
};
var _default = /*#__PURE__*/(0, _react.memo)(DismissButton);
exports.default = _default;