"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _primitives = require("@atlaskit/primitives");
var _motion = require("@atlaskit/motion");
var expanderStyles = (0, _primitives.xcss)({
  width: '100%'
});
var containerStyles = (0, _primitives.xcss)({
  transition: "max-height 0.3s"
});
var Expander = function Expander(_ref) {
  var children = _ref.children,
    isExpanded = _ref.isExpanded,
    testId = _ref.testId;
  // Need to always render the ExpanderInternal otherwise the
  // reveal transition doesn't happen. We can't use CSS animation for
  // the the reveal because we don't know the height of the content.

  return /*#__PURE__*/_react.default.createElement(_primitives.Box, {
    xcss: containerStyles,
    style: {
      maxHeight: isExpanded ? 150 : 0,
      flex: '1 1 100%',
      minWidth: 0
    },
    "aria-hidden": !isExpanded,
    testId: testId && "".concat(testId, "-expander")
  }, /*#__PURE__*/_react.default.createElement(_motion.ExitingPersistence, {
    appear: true
  }, isExpanded && /*#__PURE__*/_react.default.createElement(_motion.FadeIn, null, function (props) {
    return /*#__PURE__*/_react.default.createElement(_primitives.Box, (0, _extends2.default)({
      xcss: expanderStyles
    }, props), /*#__PURE__*/_react.default.createElement(_primitives.Stack, {
      space: "space.100"
    }, children));
  })));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var _default = Expander;
exports.default = _default;