/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */

import { B400, N0, N30A, N500, N700 } from '@atlaskit/theme/colors';
export const flagBackgroundColor = {
  error: 'color.background.danger.bold',
  info: 'color.background.neutral.bold',
  normal: 'elevation.surface.overlay',
  success: 'color.background.success.bold',
  warning: 'color.background.warning.bold'
};
export const flagIconColor = {
  error: `var(--ds-icon-inverse, ${N0})`,
  info: `var(--ds-icon-inverse, ${N0})`,
  normal: `var(--ds-icon-subtle, ${N500})`,
  success: `var(--ds-icon-inverse, ${N0})`,
  warning: `var(--ds-icon-warning-inverse, ${N700})`
};

/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */
export const flagTextColor = {
  error: 'inverse',
  info: 'inverse',
  normal: 'subtle',
  success: 'inverse',
  warning: 'warning.inverse'
};
export const flagTextColorToken = {
  error: `var(--ds-text-inverse, ${N0})`,
  info: `var(--ds-text-inverse, ${N0})`,
  normal: `var(--ds-text-subtle, ${N500})`,
  success: `var(--ds-text-inverse, ${N0})`,
  warning: `var(--ds-text-warning-inverse, ${N700})`
};
// TODO: DSP-2519 Interaction tokens should be used for hovered and pressed states
// https://product-fabric.atlassian.net/browse/DSP-2519
export const actionBackgroundColor = {
  success: {
    default: `var(--ds-background-inverse-subtle, ${N30A})`,
    active: `var(--ds-background-inverse-subtle-pressed, ${N30A})`,
    pressed: `var(--ds-background-inverse-subtle-hovered, ${N30A})`
  },
  info: {
    default: `var(--ds-background-inverse-subtle, ${N30A})`,
    active: `var(--ds-background-inverse-subtle-pressed, ${N30A})`,
    pressed: `var(--ds-background-inverse-subtle-hovered, ${N30A})`
  },
  error: {
    default: `var(--ds-background-inverse-subtle, ${N30A})`,
    active: `var(--ds-background-inverse-subtle-pressed, ${N30A})`,
    pressed: `var(--ds-background-inverse-subtle-hovered, ${N30A})`
  },
  warning: {
    default: `var(--ds-background-inverse-subtle, ${N30A})`,
    active: `var(--ds-background-inverse-subtle-pressed, ${N30A})`,
    pressed: `var(--ds-background-inverse-subtle-hovered, ${N30A})`
  },
  normal: {
    default: 'none',
    active: 'none',
    pressed: 'none'
  }
};
export const actionTextColor = {
  success: `var(--ds-text-inverse, ${N0})`,
  info: `var(--ds-text-inverse, ${N0})`,
  error: `var(--ds-text-inverse, ${N0})`,
  warning: `var(--ds-text-warning-inverse, ${N700})`,
  normal: `var(--ds-link, ${B400})`
};