import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { useCallback, useEffect, useState } from 'react';
import { jsx, css } from '@emotion/react';
import { UNSAFE_Text as Text } from '@atlaskit/ds-explorations';
import { Inline, Stack, Box, xcss } from '@atlaskit/primitives';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next/usePlatformLeafEventHandler';
import noop from '@atlaskit/ds-lib/noop';
import FocusRing from '@atlaskit/focus-ring';
import { DEFAULT_APPEARANCE } from './constants';
import { flagTextColor, flagBackgroundColor, flagIconColor } from './theme';
import Actions from './flag-actions';
import { useFlagGroup } from './flag-group';
import { Expander, DismissButton } from './internal';
var CSS_VAR_ICON_COLOR = '--flag-icon-color';
var iconWrapperStyles = css({
  display: 'flex',
  alignItems: 'start',
  flexShrink: 0,
  color: "var(".concat(CSS_VAR_ICON_COLOR, ")")
});
var flagStyles = xcss({
  boxShadow: 'elevation.shadow.overlay',
  borderRadius: 'border.radius.100',
  overflow: 'hidden',
  zIndex: 'flag',
  width: '100%',
  transition: 'background-color 200ms'
});
var flagWrapperStyles = css({
  width: '100%'
});
var analyticsAttributes = {
  componentName: 'flag',
  packageName: "@atlaskit/flag",
  packageVersion: "15.2.14"
};
var transitionStyles = css({
  flexGrow: 1,
  transition: "gap 0.3s"
});

/**
 * __Flag__
 *
 * A flag is used for confirmations, alerts, and acknowledgments that require minimal user interaction,
 * often displayed using a flag group.
 *
 * - [Examples](https://atlassian.design/components/flag/examples)
 * - [Code](https://atlassian.design/components/flag/code)
 * - [Usage](https://atlassian.design/components/flag/usage)
 */
var Flag = function Flag(props) {
  var _props$actions = props.actions,
    actions = _props$actions === void 0 ? [] : _props$actions,
    _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? DEFAULT_APPEARANCE : _props$appearance,
    icon = props.icon,
    title = props.title,
    description = props.description,
    linkComponent = props.linkComponent,
    onMouseOver = props.onMouseOver,
    _props$onFocus = props.onFocus,
    onFocus = _props$onFocus === void 0 ? noop : _props$onFocus,
    onMouseOut = props.onMouseOut,
    _props$onBlur = props.onBlur,
    onBlur = _props$onBlur === void 0 ? noop : _props$onBlur,
    _props$onDismissed = props.onDismissed,
    onDismissedProp = _props$onDismissed === void 0 ? noop : _props$onDismissed,
    testId = props.testId,
    id = props.id,
    analyticsContext = props.analyticsContext;
  var _useFlagGroup = useFlagGroup(),
    onDismissedFromFlagGroup = _useFlagGroup.onDismissed,
    isDismissAllowed = _useFlagGroup.isDismissAllowed;
  var onDismissed = useCallback(function (id, analyticsEvent) {
    onDismissedProp(id, analyticsEvent);
    onDismissedFromFlagGroup(id, analyticsEvent);
  }, [onDismissedProp, onDismissedFromFlagGroup]);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isExpanded = _useState2[0],
    setIsExpanded = _useState2[1];
  var onDismissedAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: onDismissed,
    action: 'dismissed',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var isBold = appearance !== DEFAULT_APPEARANCE;
  var toggleExpand = useCallback(function () {
    setIsExpanded(function (previous) {
      return !previous;
    });
  }, []);
  var buttonActionCallback = useCallback(function () {
    if (isDismissAllowed) {
      onDismissedAnalytics(id);
    }
  }, [onDismissedAnalytics, id, isDismissAllowed]);
  useEffect(function () {
    // If buttons are removed as a prop, update isExpanded to be false
    if (isBold && isExpanded && !description && !actions.length) {
      setIsExpanded(false);
    }
  }, [actions.length, description, isBold, isExpanded]);
  var onFocusAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: onFocus,
    action: 'focused',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var onBlurAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: onBlur,
    action: 'blurred',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var autoDismissProps = {
    onMouseOver: onMouseOver,
    onFocus: onFocusAnalytics,
    onMouseOut: onMouseOut,
    onBlur: onBlurAnalytics
  };
  var textColor = flagTextColor[appearance];
  var iconColor = flagIconColor[appearance];
  var isDismissable = isBold || isDismissAllowed;
  var shouldRenderGap = !isBold && (description || actions.length) || isExpanded;
  return jsx(FocusRing, null, jsx("div", _extends({
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    tabIndex: 0,
    role: "alert",
    css: flagWrapperStyles,
    "data-testid": testId
  }, autoDismissProps), jsx(Box, {
    backgroundColor: flagBackgroundColor[appearance],
    padding: "space.200",
    xcss: flagStyles
  }, jsx(Inline, {
    alignBlock: "stretch",
    space: "space.200"
  }, jsx("div", {
    css: iconWrapperStyles,
    style: _defineProperty({}, CSS_VAR_ICON_COLOR, iconColor)
  }, icon), jsx("span", {
    css: transitionStyles
  }, jsx(Stack, {
    space: shouldRenderGap ? 'space.100' : 'space.0' // Gap exists even when not expanded due to Expander internals always being in the DOM
  }, jsx(Inline, {
    alignBlock: "stretch",
    space: "space.100",
    spread: "space-between"
  }, jsx(Box, {
    paddingBlockStart: "space.025"
  }, jsx(Text, {
    color: textColor,
    fontWeight: "semibold",
    UNSAFE_style: {
      overflowWrap: 'anywhere' // For cases where a single word is longer than the container (e.g. filenames)
    }
  }, title)), isDismissable ? !(isBold && !description && !actions.length) && jsx(DismissButton, {
    testId: testId,
    appearance: appearance,
    isBold: isBold,
    isExpanded: isExpanded,
    onClick: isBold ? toggleExpand : buttonActionCallback
  }) : null), jsx(Expander, {
    isExpanded: !isBold || isExpanded,
    testId: testId
  }, description && jsx(Text, {
    as: "div",
    color: textColor,
    UNSAFE_style: {
      maxHeight: 100,
      // height is defined as 5 lines maximum by design
      overflow: 'auto',
      overflowWrap: 'anywhere' // For cases where a single word is longer than the container (e.g. filenames)
    },

    testId: testId && "".concat(testId, "-description")
  }, description), jsx(Actions, {
    actions: actions,
    appearance: appearance,
    linkComponent: linkComponent,
    testId: testId
  }))))))));
};
export default Flag;