import { ReactElement } from 'react';
import { jsx } from '@emotion/react';
import type { UIAnalyticsEvent } from '@atlaskit/analytics-next';
type FlagGroupProps = {
    /**
     * ID attribute used for DOM selection.
     */
    id?: string;
    /**
     * Describes the specific role of this FlagGroup for users viewing the page with a screen reader (defaults to `Flag notifications`).
     */
    label?: string;
    /**
     * Describes the specific tag on which the screen reader text will be rendered (defaults to `h2`).
     */
    labelTag?: React.ElementType;
    /**
     * Flag elements to be displayed.
     */
    children?: Array<ReactElement> | ReactElement | null | boolean;
    /**
     * Handler which will be called when a Flag's dismiss button is clicked.
     * Receives the id of the dismissed Flag as a parameter.
     */
    onDismissed?: (id: number | string, analyticsEvent: UIAnalyticsEvent) => void;
};
export declare const flagWidth: number;
export declare const flagAnimationTime = 400;
type FlagGroupAPI = {
    onDismissed: (id: number | string, analyticsEvent: UIAnalyticsEvent) => void;
    isDismissAllowed: boolean;
};
export declare const FlagGroupContext: import("react").Context<FlagGroupAPI>;
export declare function useFlagGroup(): FlagGroupAPI;
/**
 * __Flag group__
 *
 * A flag group is used to group a set of related flags, with entry and exit animations.
 *
 * - [Examples](https://atlassian.design/components/flag/flag-group/examples)
 * - [Code](https://atlassian.design/components/flag/flag-group/code)
 */
declare const FlagGroup: (props: FlagGroupProps) => jsx.JSX.Element;
export default FlagGroup;
