import { UNSAFE_TextProps as TextProps } from '@atlaskit/ds-explorations';
import { BoxProps } from '@atlaskit/primitives';
import { AppearanceTypes } from './types';
export declare const flagBackgroundColor: Record<AppearanceTypes, BoxProps['backgroundColor']>;
export declare const flagIconColor: Record<AppearanceTypes, string>;
export declare const flagTextColor: Record<AppearanceTypes, TextProps['color']>;
export declare const flagTextColorToken: {
    error: "var(--ds-text-inverse)";
    info: "var(--ds-text-inverse)";
    normal: "var(--ds-text-subtle)";
    success: "var(--ds-text-inverse)";
    warning: "var(--ds-text-warning-inverse)";
};
type ActionBackgroundColor = Record<Exclude<AppearanceTypes, 'normal'>, {
    default: 'var(--ds-background-inverse-subtle)';
    active: 'var(--ds-background-inverse-subtle-pressed)';
    pressed: 'var(--ds-background-inverse-subtle-hovered)';
}> & Record<Extract<AppearanceTypes, 'normal'>, {
    default: 'none';
    active: 'none';
    pressed: 'none';
}>;
export declare const actionBackgroundColor: ActionBackgroundColor;
export declare const actionTextColor: Record<AppearanceTypes, string>;
export {};
