<!-- API Report Version: 2.3 -->

## API Report File for "@atlaskit/flag"

> Do not edit this file. This report is auto-generated using [API Extractor](https://api-extractor.com/).
> [Learn more about API reports](https://hello.atlassian.net/wiki/spaces/UR/pages/1825484529/Package+API+Reports)

### Table of contents

- [Main Entry Types](#main-entry-types)
- [Peer Dependencies](#peer-dependencies)

### Main Entry Types

<!--SECTION START: Main Entry Types-->

```ts
/// <reference types="react" />

import { ComponentType } from 'react';
import { CustomThemeButtonProps } from '@atlaskit/button/types';
import { FC } from 'react';
import { jsx } from '@emotion/react';
import { MouseEventHandler } from 'react';
import { default as React_2 } from 'react';
import { ReactElement } from 'react';
import { ReactNode } from 'react';
import { UIAnalyticsEvent } from '@atlaskit/analytics-next';
import { WithAnalyticsEventsProps } from '@atlaskit/analytics-next';

// @public (undocumented)
export type ActionsType = Array<ActionType>;

// @public (undocumented)
type ActionType = {
  content: ReactNode;
  onClick?: (
    e: React.MouseEvent<HTMLElement>,
    analyticsEvent: UIAnalyticsEvent,
  ) => void;
  href?: string;
  target?: string;
  testId?: string;
};

// @public (undocumented)
export type AppearanceTypes =
  | 'error'
  | 'info'
  | 'normal'
  | 'success'
  | 'warning';

// @public
export const AutoDismissFlag: (props: AutoDismissFlagProps) => JSX.Element;

// @public (undocumented)
interface AutoDismissFlagProps
  extends AutoDismissFlagPropsWithoutId,
    FlagPropsId {}

// @public (undocumented)
type AutoDismissFlagPropsWithoutId = {
  actions?: ActionsType;
  appearance?: AppearanceTypes;
  description?: ReactNode;
  icon: ReactNode;
  title: ReactNode;
  onDismissed?: (id: number | string, analyticsEvent: UIAnalyticsEvent) => void;
  linkComponent?: ComponentType<CustomThemeButtonProps>;
  testId?: string;
  analyticsContext?: Record<string, any>;
};

// @public (undocumented)
type Combine<First, Second> = Omit<First, keyof Second> & Second;

// @public (undocumented)
export interface CreateFlagArgs extends FlagPropsWithoutId {
  id?: FlagId;
  isAutoDismiss?: boolean;
}

// @public (undocumented)
export type DismissFn = () => void;

// @public
const Flag: FC<FlagProps>;
export default Flag;

// @public (undocumented)
export type FlagAPI = {
  showFlag: (args: CreateFlagArgs) => DismissFn;
};

// @public (undocumented)
export type FlagArgs = Combine<
  CreateFlagArgs,
  {
    id: FlagId;
  }
>;

// @public
export const FlagGroup: (props: FlagGroupProps) => jsx.JSX.Element;

// @public (undocumented)
type FlagGroupProps = {
  id?: string;
  label?: string;
  labelTag?: React.ElementType;
  children?: Array<ReactElement> | ReactElement | boolean | null;
  onDismissed?: (id: number | string, analyticsEvent: UIAnalyticsEvent) => void;
};

// @public (undocumented)
type FlagId = number | string;

// @public (undocumented)
export interface FlagProps extends FlagPropsWithoutId, FlagPropsId {}

// @public (undocumented)
type FlagPropsId = {
  id: number | string;
};

// @public (undocumented)
interface FlagPropsWithoutId
  extends AutoDismissFlagPropsWithoutId,
    WithAnalyticsEventsProps {
  onBlur?: (
    e: React.FocusEvent<HTMLElement>,
    analyticsEvent: UIAnalyticsEvent,
  ) => void;
  onFocus?: (
    e: React.FocusEvent<HTMLElement>,
    analyticsEvent: UIAnalyticsEvent,
  ) => void;
  onMouseOut?: MouseEventHandler;
  onMouseOver?: MouseEventHandler;
}

// @public (undocumented)
export function FlagsProvider({
  children,
}: {
  children: React_2.ReactNode;
}): JSX.Element;

// @public
export function useFlags(): FlagAPI;

// @public (undocumented)
export const withFlagsProvider: (
  fn: () => React_2.ReactNode,
) => React_2.ReactNode;

// (No @packageDocumentation comment for this package)
```

<!--SECTION END: Main Entry Types-->

### Peer Dependencies

<!--SECTION START: Peer Dependencies-->

```json
{
  "react": "^16.8.0"
}
```

<!--SECTION END: Peer Dependencies-->
