"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AUTO_DISMISS_SECONDS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _usePlatformLeafEventHandler = require("@atlaskit/analytics-next/usePlatformLeafEventHandler");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _flag = _interopRequireDefault(require("./flag"));
var _flagGroup = require("./flag-group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var packageName = "@atlaskit/flag";
var packageVersion = "15.2.15";
var AUTO_DISMISS_SECONDS = 8;

/**
 * __Auto dismiss flag__
 *
 * An auto dismiss flag is dismissed automatically after eight seconds.
 *
 * - [Examples](https://atlassian.design/components/flag/auto-dismiss-flag/examples)
 * - [Code](https://atlassian.design/components/flag/auto-dismiss-flag/code)
 */
exports.AUTO_DISMISS_SECONDS = AUTO_DISMISS_SECONDS;
var AutoDismissFlag = function AutoDismissFlag(props) {
  var id = props.id,
    analyticsContext = props.analyticsContext,
    _props$onDismissed = props.onDismissed,
    onDismissedProp = _props$onDismissed === void 0 ? _noop.default : _props$onDismissed;
  var autoDismissTimer = (0, _react.useRef)(null);
  var _useFlagGroup = (0, _flagGroup.useFlagGroup)(),
    onDismissedFromFlagGroup = _useFlagGroup.onDismissed,
    isDismissAllowed = _useFlagGroup.isDismissAllowed;
  var onDismissed = (0, _react.useCallback)(function (id, analyticsEvent) {
    onDismissedProp(id, analyticsEvent);
    onDismissedFromFlagGroup(id, analyticsEvent);
  }, [onDismissedProp, onDismissedFromFlagGroup]);
  var onDismissedAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)({
    fn: onDismissed,
    action: 'dismissed',
    analyticsData: analyticsContext,
    componentName: 'flag',
    packageName: packageName,
    packageVersion: packageVersion
  });
  var isAutoDismissAllowed = isDismissAllowed && onDismissed;
  var dismissFlag = (0, _react.useCallback)(function () {
    if (isAutoDismissAllowed) {
      onDismissedAnalytics(id);
    }
  }, [id, onDismissedAnalytics, isAutoDismissAllowed]);
  var stopAutoDismissTimer = (0, _react.useCallback)(function () {
    if (autoDismissTimer.current) {
      clearTimeout(autoDismissTimer.current);
      autoDismissTimer.current = null;
    }
  }, []);
  var startAutoDismissTimer = (0, _react.useCallback)(function () {
    if (!isAutoDismissAllowed) {
      return;
    }
    stopAutoDismissTimer();
    autoDismissTimer.current = window.setTimeout(dismissFlag, AUTO_DISMISS_SECONDS * 1000);
  }, [dismissFlag, stopAutoDismissTimer, isAutoDismissAllowed]);
  (0, _react.useEffect)(function () {
    startAutoDismissTimer();
    return stopAutoDismissTimer;
  }, [startAutoDismissTimer, stopAutoDismissTimer]);
  return /*#__PURE__*/_react.default.createElement(_flag.default
  // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  , (0, _extends2.default)({}, props, {
    onMouseOver: stopAutoDismissTimer,
    onFocus: stopAutoDismissTimer,
    onMouseOut: startAutoDismissTimer,
    onBlur: startAutoDismissTimer
  }));
};
var _default = AutoDismissFlag;
exports.default = _default;