"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flagWidth = exports.flagAnimationTime = exports.default = exports.FlagGroupContext = void 0;
exports.useFlagGroup = useFlagGroup;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _motion = require("@atlaskit/motion");
var _visuallyHidden = _interopRequireDefault(require("@atlaskit/visually-hidden"));
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _portal = _interopRequireDefault(require("@atlaskit/portal"));
var _constants = require("@atlaskit/theme/constants");
/** @jsx jsx */

// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports

var gridSize = (0, _constants.gridSize)();
var flagWidth = gridSize * 50;
exports.flagWidth = flagWidth;
var flagAnimationTime = 400;
exports.flagAnimationTime = flagAnimationTime;
var defaultFlagGroupContext = {
  onDismissed: _noop.default,
  isDismissAllowed: false
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var FlagGroupContext = /*#__PURE__*/(0, _react.createContext)(defaultFlagGroupContext);

// eslint-disable-next-line @repo/internal/react/require-jsdoc
exports.FlagGroupContext = FlagGroupContext;
function useFlagGroup() {
  return (0, _react.useContext)(FlagGroupContext);
}

// transition: none is set on first-of-type to prevent a bug in Firefox
// that causes a broken transition
var baseStyles = (0, _react2.css)({
  width: flagWidth,
  position: 'absolute',
  bottom: 0,
  transition: "transform ".concat(flagAnimationTime, "ms ease-in-out"),
  '@media (max-width: 560px)': {
    width: '100vw'
  },
  ':first-of-type': {
    transform: "translate(0,0)",
    transition: 'none'
  },
  ':nth-of-type(n + 2)': {
    animationDuration: '0ms',
    transform: "translateX(0) translateY(100%) translateY(".concat(2 * gridSize, "px)")
  },
  ':nth-of-type(1)': {
    zIndex: 5
  },
  ':nth-of-type(2)': {
    zIndex: 4
  },
  '&:nth-of-type(n + 4)': {
    visibility: 'hidden'
  }
});

// Transform needed to push up while 1st flag is leaving
// Exiting time should match the exiting time of motion so is halved
var dismissAllowedStyles = (0, _react2.css)({
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '&& + *': {
    transform: "translate(0, 0)",
    transitionDuration: "".concat(flagAnimationTime / 2, "ms")
  }
});
var flagGroupContainerStyles = (0, _react2.css)({
  position: 'fixed',
  zIndex: 'flag',
  bottom: "var(--ds-space-600, 48px)",
  left: "var(--ds-space-1000, 80px)",
  '@media (max-width: 560px)': {
    bottom: 0,
    left: 0
  }
});

/**
 * __Flag group__
 *
 * A flag group is used to group a set of related flags, with entry and exit animations.
 *
 * - [Examples](https://atlassian.design/components/flag/flag-group/examples)
 * - [Code](https://atlassian.design/components/flag/flag-group/code)
 */
var FlagGroup = function FlagGroup(props) {
  var id = props.id,
    _props$label = props.label,
    label = _props$label === void 0 ? 'Flag notifications' : _props$label,
    _props$labelTag = props.labelTag,
    LabelTag = _props$labelTag === void 0 ? 'h2' : _props$labelTag,
    children = props.children,
    _props$onDismissed = props.onDismissed,
    onDismissed = _props$onDismissed === void 0 ? _noop.default : _props$onDismissed;
  var hasFlags = Array.isArray(children) ? children.length > 0 : Boolean(children);
  var dismissFlagContext = (0, _react.useMemo)(function () {
    return {
      onDismissed: onDismissed,
      isDismissAllowed: true
    };
  }, [onDismissed]);
  var renderChildren = function renderChildren() {
    return children && (0, _typeof2.default)(children) === 'object' ? _react.Children.map(children, function (flag, index) {
      var isDismissAllowed = index === 0;
      return (0, _react2.jsx)(_motion.SlideIn, {
        enterFrom: "left",
        fade: "inout",
        duration: flagAnimationTime,
        animationTimingFunction: function animationTimingFunction() {
          return _motion.easeIn;
        }
      }, function (_ref) {
        var className = _ref.className,
          ref = _ref.ref;
        return (0, _react2.jsx)("div", {
          css: [baseStyles, isDismissAllowed && dismissAllowedStyles],
          className: className,
          ref: ref
        }, (0, _react2.jsx)(FlagGroupContext.Provider, {
          value:
          // Only the first flag should be able to be dismissed.
          isDismissAllowed ? dismissFlagContext : defaultFlagGroupContext
        }, flag));
      });
    }) : false;
  };
  return (0, _react2.jsx)(_portal.default, {
    zIndex: _constants.layers.flag()
  }, (0, _react2.jsx)("div", {
    id: id,
    css: flagGroupContainerStyles
  }, hasFlags ? (0, _react2.jsx)(_visuallyHidden.default, null, (0, _react2.jsx)(LabelTag, null, label)) : null, (0, _react2.jsx)(_motion.ExitingPersistence, {
    appear: false
  }, renderChildren())));
};
var _default = FlagGroup;
exports.default = _default;