"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _dsExplorations = require("@atlaskit/ds-explorations");
var _primitives = require("@atlaskit/primitives");
var _usePlatformLeafEventHandler = require("@atlaskit/analytics-next/usePlatformLeafEventHandler");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _focusRing = _interopRequireDefault(require("@atlaskit/focus-ring"));
var _constants = require("./constants");
var _theme = require("./theme");
var _flagActions = _interopRequireDefault(require("./flag-actions"));
var _flagGroup = require("./flag-group");
var _internal = require("./internal");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var CSS_VAR_ICON_COLOR = '--flag-icon-color';
var iconWrapperStyles = (0, _react2.css)({
  display: 'flex',
  alignItems: 'start',
  flexShrink: 0,
  color: "var(".concat(CSS_VAR_ICON_COLOR, ")")
});
var flagStyles = (0, _primitives.xcss)({
  boxShadow: 'elevation.shadow.overlay',
  borderRadius: 'border.radius.100',
  overflow: 'hidden',
  zIndex: 'flag',
  width: '100%',
  transition: 'background-color 200ms'
});
var flagWrapperStyles = (0, _react2.css)({
  width: '100%'
});
var analyticsAttributes = {
  componentName: 'flag',
  packageName: "@atlaskit/flag",
  packageVersion: "15.2.15"
};
var transitionStyles = (0, _react2.css)({
  flexGrow: 1,
  transition: "gap 0.3s"
});

/**
 * __Flag__
 *
 * A flag is used for confirmations, alerts, and acknowledgments that require minimal user interaction,
 * often displayed using a flag group.
 *
 * - [Examples](https://atlassian.design/components/flag/examples)
 * - [Code](https://atlassian.design/components/flag/code)
 * - [Usage](https://atlassian.design/components/flag/usage)
 */
var Flag = function Flag(props) {
  var _props$actions = props.actions,
    actions = _props$actions === void 0 ? [] : _props$actions,
    _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? _constants.DEFAULT_APPEARANCE : _props$appearance,
    icon = props.icon,
    title = props.title,
    description = props.description,
    linkComponent = props.linkComponent,
    onMouseOver = props.onMouseOver,
    _props$onFocus = props.onFocus,
    onFocus = _props$onFocus === void 0 ? _noop.default : _props$onFocus,
    onMouseOut = props.onMouseOut,
    _props$onBlur = props.onBlur,
    onBlur = _props$onBlur === void 0 ? _noop.default : _props$onBlur,
    _props$onDismissed = props.onDismissed,
    onDismissedProp = _props$onDismissed === void 0 ? _noop.default : _props$onDismissed,
    testId = props.testId,
    id = props.id,
    analyticsContext = props.analyticsContext;
  var _useFlagGroup = (0, _flagGroup.useFlagGroup)(),
    onDismissedFromFlagGroup = _useFlagGroup.onDismissed,
    isDismissAllowed = _useFlagGroup.isDismissAllowed;
  var onDismissed = (0, _react.useCallback)(function (id, analyticsEvent) {
    onDismissedProp(id, analyticsEvent);
    onDismissedFromFlagGroup(id, analyticsEvent);
  }, [onDismissedProp, onDismissedFromFlagGroup]);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isExpanded = _useState2[0],
    setIsExpanded = _useState2[1];
  var onDismissedAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)(_objectSpread({
    fn: onDismissed,
    action: 'dismissed',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var isBold = appearance !== _constants.DEFAULT_APPEARANCE;
  var toggleExpand = (0, _react.useCallback)(function () {
    setIsExpanded(function (previous) {
      return !previous;
    });
  }, []);
  var buttonActionCallback = (0, _react.useCallback)(function () {
    if (isDismissAllowed) {
      onDismissedAnalytics(id);
    }
  }, [onDismissedAnalytics, id, isDismissAllowed]);
  (0, _react.useEffect)(function () {
    // If buttons are removed as a prop, update isExpanded to be false
    if (isBold && isExpanded && !description && !actions.length) {
      setIsExpanded(false);
    }
  }, [actions.length, description, isBold, isExpanded]);
  var onFocusAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)(_objectSpread({
    fn: onFocus,
    action: 'focused',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var onBlurAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)(_objectSpread({
    fn: onBlur,
    action: 'blurred',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var autoDismissProps = {
    onMouseOver: onMouseOver,
    onFocus: onFocusAnalytics,
    onMouseOut: onMouseOut,
    onBlur: onBlurAnalytics
  };
  var textColor = _theme.flagTextColor[appearance];
  var iconColor = _theme.flagIconColor[appearance];
  var isDismissable = isBold || isDismissAllowed;
  var shouldRenderGap = !isBold && (description || actions.length) || isExpanded;
  return (0, _react2.jsx)(_focusRing.default, null, (0, _react2.jsx)("div", (0, _extends2.default)({
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    tabIndex: 0,
    role: "alert",
    css: flagWrapperStyles,
    "data-testid": testId
  }, autoDismissProps), (0, _react2.jsx)(_primitives.Box, {
    backgroundColor: _theme.flagBackgroundColor[appearance],
    padding: "space.200",
    xcss: flagStyles
  }, (0, _react2.jsx)(_primitives.Inline, {
    alignBlock: "stretch",
    space: "space.200"
  }, (0, _react2.jsx)("div", {
    css: iconWrapperStyles,
    style: (0, _defineProperty2.default)({}, CSS_VAR_ICON_COLOR, iconColor)
  }, icon), (0, _react2.jsx)("span", {
    css: transitionStyles
  }, (0, _react2.jsx)(_primitives.Stack, {
    space: shouldRenderGap ? 'space.100' : 'space.0' // Gap exists even when not expanded due to Expander internals always being in the DOM
  }, (0, _react2.jsx)(_primitives.Inline, {
    alignBlock: "stretch",
    space: "space.100",
    spread: "space-between"
  }, (0, _react2.jsx)(_primitives.Box, {
    paddingBlockStart: "space.025"
  }, (0, _react2.jsx)(_dsExplorations.UNSAFE_Text, {
    color: textColor,
    fontWeight: "semibold",
    UNSAFE_style: {
      overflowWrap: 'anywhere' // For cases where a single word is longer than the container (e.g. filenames)
    }
  }, title)), isDismissable ? !(isBold && !description && !actions.length) && (0, _react2.jsx)(_internal.DismissButton, {
    testId: testId,
    appearance: appearance,
    isBold: isBold,
    isExpanded: isExpanded,
    onClick: isBold ? toggleExpand : buttonActionCallback
  }) : null), (0, _react2.jsx)(_internal.Expander, {
    isExpanded: !isBold || isExpanded,
    testId: testId
  }, description && (0, _react2.jsx)(_dsExplorations.UNSAFE_Text, {
    as: "div",
    color: textColor,
    UNSAFE_style: {
      maxHeight: 100,
      // height is defined as 5 lines maximum by design
      overflow: 'auto',
      overflowWrap: 'anywhere' // For cases where a single word is longer than the container (e.g. filenames)
    },

    testId: testId && "".concat(testId, "-description")
  }, description), (0, _react2.jsx)(_flagActions.default, {
    actions: actions,
    appearance: appearance,
    linkComponent: linkComponent,
    testId: testId
  }))))))));
};
var _default = Flag;
exports.default = _default;