"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flagTextColorToken = exports.flagTextColor = exports.flagIconColor = exports.flagBackgroundColor = exports.actionTextColor = exports.actionBackgroundColor = void 0;
var _colors = require("@atlaskit/theme/colors");
/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */

var flagBackgroundColor = {
  error: 'color.background.danger.bold',
  info: 'color.background.neutral.bold',
  normal: 'elevation.surface.overlay',
  success: 'color.background.success.bold',
  warning: 'color.background.warning.bold'
};
exports.flagBackgroundColor = flagBackgroundColor;
var flagIconColor = {
  error: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
  info: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
  normal: "var(--ds-icon-subtle, ".concat(_colors.N500, ")"),
  success: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
  warning: "var(--ds-icon-warning-inverse, ".concat(_colors.N700, ")")
};

/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */
exports.flagIconColor = flagIconColor;
var flagTextColor = {
  error: 'inverse',
  info: 'inverse',
  normal: 'subtle',
  success: 'inverse',
  warning: 'warning.inverse'
};
exports.flagTextColor = flagTextColor;
var flagTextColorToken = {
  error: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  info: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  normal: "var(--ds-text-subtle, ".concat(_colors.N500, ")"),
  success: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  warning: "var(--ds-text-warning-inverse, ".concat(_colors.N700, ")")
};
exports.flagTextColorToken = flagTextColorToken;
// TODO: DSP-2519 Interaction tokens should be used for hovered and pressed states
// https://product-fabric.atlassian.net/browse/DSP-2519
var actionBackgroundColor = {
  success: {
    default: "var(--ds-background-inverse-subtle, ".concat(_colors.N30A, ")"),
    active: "var(--ds-background-inverse-subtle-pressed, ".concat(_colors.N30A, ")"),
    pressed: "var(--ds-background-inverse-subtle-hovered, ".concat(_colors.N30A, ")")
  },
  info: {
    default: "var(--ds-background-inverse-subtle, ".concat(_colors.N30A, ")"),
    active: "var(--ds-background-inverse-subtle-pressed, ".concat(_colors.N30A, ")"),
    pressed: "var(--ds-background-inverse-subtle-hovered, ".concat(_colors.N30A, ")")
  },
  error: {
    default: "var(--ds-background-inverse-subtle, ".concat(_colors.N30A, ")"),
    active: "var(--ds-background-inverse-subtle-pressed, ".concat(_colors.N30A, ")"),
    pressed: "var(--ds-background-inverse-subtle-hovered, ".concat(_colors.N30A, ")")
  },
  warning: {
    default: "var(--ds-background-inverse-subtle, ".concat(_colors.N30A, ")"),
    active: "var(--ds-background-inverse-subtle-pressed, ".concat(_colors.N30A, ")"),
    pressed: "var(--ds-background-inverse-subtle-hovered, ".concat(_colors.N30A, ")")
  },
  normal: {
    default: 'none',
    active: 'none',
    pressed: 'none'
  }
};
exports.actionBackgroundColor = actionBackgroundColor;
var actionTextColor = {
  success: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  info: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  error: "var(--ds-text-inverse, ".concat(_colors.N0, ")"),
  warning: "var(--ds-text-warning-inverse, ".concat(_colors.N700, ")"),
  normal: "var(--ds-link, ".concat(_colors.B400, ")")
};
exports.actionTextColor = actionTextColor;