/** @jsx jsx */
import { memo } from 'react';
import { css, jsx } from '@emotion/react';
import FocusRing from '@atlaskit/focus-ring';
import ChevronDownIcon from '@atlaskit/icon/glyph/hipchat/chevron-down';
import ChevronUpIcon from '@atlaskit/icon/glyph/hipchat/chevron-up';
import CrossIcon from '@atlaskit/icon/glyph/cross';
import { flagTextColorToken } from '../theme';
const buttonStyles = css({
  display: 'flex',
  width: '24px',
  height: '24px',
  padding: "var(--ds-space-0, 0px)",
  alignItems: 'center',
  justifyContent: 'center',
  flex: '0 0 auto',
  background: 'none',
  borderStyle: 'none',
  cursor: 'pointer',
  whiteSpace: 'nowrap'
});
const DismissButton = ({
  appearance,
  onClick,
  isBold,
  isExpanded,
  testId
}) => {
  let ButtonIcon = CrossIcon;
  let buttonLabel = 'Dismiss';
  let size = 'small';
  let buttonTestId = testId && `${testId}-dismiss`;
  if (isBold) {
    ButtonIcon = isExpanded ? ChevronUpIcon : ChevronDownIcon;
    buttonLabel = isExpanded ? 'Collapse' : 'Expand';
    size = 'medium';
    buttonTestId = testId && `${testId}-toggle`;
  }
  return jsx(FocusRing, null, jsx("button", {
    type: "button",
    css: buttonStyles,
    onClick: onClick,
    "aria-expanded": isBold ? isExpanded : undefined,
    "data-testid": buttonTestId
  }, jsx(ButtonIcon, {
    label: buttonLabel,
    size: size,
    primaryColor: flagTextColorToken[appearance]
  })));
};
export default /*#__PURE__*/memo(DismissButton);