import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import { xcss, Stack, Box } from '@atlaskit/primitives';
import { ExitingPersistence, FadeIn } from '@atlaskit/motion';
const expanderStyles = xcss({
  width: '100%'
});
const containerStyles = xcss({
  transition: `max-height 0.3s`
});
const Expander = ({
  children,
  isExpanded,
  testId
}) => {
  // Need to always render the ExpanderInternal otherwise the
  // reveal transition doesn't happen. We can't use CSS animation for
  // the the reveal because we don't know the height of the content.

  return /*#__PURE__*/React.createElement(Box, {
    xcss: containerStyles,
    style: {
      maxHeight: isExpanded ? 150 : 0,
      flex: '1 1 100%',
      minWidth: 0
    },
    "aria-hidden": !isExpanded,
    testId: testId && `${testId}-expander`
  }, /*#__PURE__*/React.createElement(ExitingPersistence, {
    appear: true
  }, isExpanded && /*#__PURE__*/React.createElement(FadeIn, null, props => /*#__PURE__*/React.createElement(Box, _extends({
    xcss: expanderStyles
  }, props), /*#__PURE__*/React.createElement(Stack, {
    space: "space.100"
  }, children)))));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
export default Expander;