import _extends from "@babel/runtime/helpers/extends";
import React, { useCallback, useEffect, useRef } from 'react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next/usePlatformLeafEventHandler';
import noop from '@atlaskit/ds-lib/noop';
import Flag from './flag';
import { useFlagGroup } from './flag-group';
var packageName = "@atlaskit/flag";
var packageVersion = "15.2.15";
export var AUTO_DISMISS_SECONDS = 8;

/**
 * __Auto dismiss flag__
 *
 * An auto dismiss flag is dismissed automatically after eight seconds.
 *
 * - [Examples](https://atlassian.design/components/flag/auto-dismiss-flag/examples)
 * - [Code](https://atlassian.design/components/flag/auto-dismiss-flag/code)
 */
var AutoDismissFlag = function AutoDismissFlag(props) {
  var id = props.id,
    analyticsContext = props.analyticsContext,
    _props$onDismissed = props.onDismissed,
    onDismissedProp = _props$onDismissed === void 0 ? noop : _props$onDismissed;
  var autoDismissTimer = useRef(null);
  var _useFlagGroup = useFlagGroup(),
    onDismissedFromFlagGroup = _useFlagGroup.onDismissed,
    isDismissAllowed = _useFlagGroup.isDismissAllowed;
  var onDismissed = useCallback(function (id, analyticsEvent) {
    onDismissedProp(id, analyticsEvent);
    onDismissedFromFlagGroup(id, analyticsEvent);
  }, [onDismissedProp, onDismissedFromFlagGroup]);
  var onDismissedAnalytics = usePlatformLeafEventHandler({
    fn: onDismissed,
    action: 'dismissed',
    analyticsData: analyticsContext,
    componentName: 'flag',
    packageName: packageName,
    packageVersion: packageVersion
  });
  var isAutoDismissAllowed = isDismissAllowed && onDismissed;
  var dismissFlag = useCallback(function () {
    if (isAutoDismissAllowed) {
      onDismissedAnalytics(id);
    }
  }, [id, onDismissedAnalytics, isAutoDismissAllowed]);
  var stopAutoDismissTimer = useCallback(function () {
    if (autoDismissTimer.current) {
      clearTimeout(autoDismissTimer.current);
      autoDismissTimer.current = null;
    }
  }, []);
  var startAutoDismissTimer = useCallback(function () {
    if (!isAutoDismissAllowed) {
      return;
    }
    stopAutoDismissTimer();
    autoDismissTimer.current = window.setTimeout(dismissFlag, AUTO_DISMISS_SECONDS * 1000);
  }, [dismissFlag, stopAutoDismissTimer, isAutoDismissAllowed]);
  useEffect(function () {
    startAutoDismissTimer();
    return stopAutoDismissTimer;
  }, [startAutoDismissTimer, stopAutoDismissTimer]);
  return /*#__PURE__*/React.createElement(Flag
  // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  , _extends({}, props, {
    onMouseOver: stopAutoDismissTimer,
    onFocus: stopAutoDismissTimer,
    onMouseOut: startAutoDismissTimer,
    onBlur: startAutoDismissTimer
  }));
};
export default AutoDismissFlag;