import _defineProperty from "@babel/runtime/helpers/defineProperty";
/* eslint-disable @repo/internal/styles/no-nested-styles */
/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import Button from '@atlaskit/button/custom-theme-button';
import Inline from '@atlaskit/primitives/inline';
import { DEFAULT_APPEARANCE, VAR_COLOR, VAR_BG_COLOR, VAR_BG_COLOR_HOVER, VAR_BG_COLOR_ACTIVE } from './constants';
import { actionBackgroundColor, actionTextColor } from './theme';
var buttonStyles = css({
  '&&, a&&': {
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    padding: "0 ".concat("var(--ds-space-100, 8px)", " !important"),
    background: "var(".concat(VAR_BG_COLOR, ")"),
    color: "var(".concat(VAR_COLOR, ") !important"),
    fontWeight: "var(--ds-font-weight-medium, 500)"
  },
  '&&:hover, &&:active, a&&:hover, a&&:active': {
    textDecoration: 'underline'
  },
  '&&:hover': {
    backgroundColor: "var(".concat(VAR_BG_COLOR_HOVER, ")")
  },
  '&&:active': {
    backgroundColor: "var(".concat(VAR_BG_COLOR_ACTIVE, ")")
  }
});
var appearanceNormalButtonStyles = css({
  '&&, a&&': {
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    padding: '0 !important'
  }
});
var appearanceNormalActionsContainerStyles = css({
  '&&, a&&': {
    transform: 'translateX(-2px)'
  }
});
var FlagActions = function FlagActions(props) {
  var _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? DEFAULT_APPEARANCE : _props$appearance,
    _props$actions = props.actions,
    actions = _props$actions === void 0 ? [] : _props$actions,
    linkComponent = props.linkComponent,
    testId = props.testId;
  if (!actions.length) {
    return null;
  }
  var isBold = appearance !== DEFAULT_APPEARANCE;
  return jsx("span", {
    css: !isBold && appearanceNormalActionsContainerStyles
  }, jsx(Inline, {
    space: "space.100",
    shouldWrap: true,
    alignBlock: "center",
    separator: isBold ? undefined : '·',
    testId: testId && "".concat(testId, "-actions")
  }, actions.map(function (action, index) {
    var _ref;
    return jsx(Button, {
      onClick: action.onClick,
      href: action.href,
      target: action.target,
      appearance: isBold ? 'default' : 'link',
      component: linkComponent,
      spacing: "compact",
      testId: action.testId,
      key: index,
      style: (_ref = {}, _defineProperty(_ref, VAR_COLOR, actionTextColor[appearance]), _defineProperty(_ref, VAR_BG_COLOR, actionBackgroundColor[appearance].default), _defineProperty(_ref, VAR_BG_COLOR_HOVER, actionBackgroundColor[appearance].pressed), _defineProperty(_ref, VAR_BG_COLOR_ACTIVE, actionBackgroundColor[appearance].active), _ref),
      css: [buttonStyles, appearance === DEFAULT_APPEARANCE && appearanceNormalButtonStyles]
    }, action.content);
  })));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
export default FlagActions;