import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["isAutoDismiss"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import React, { useCallback, useContext, useMemo, useState } from 'react';
import AutoDismissFlag from './auto-dismiss-flag';
import Flag from './flag';
import FlagGroup from './flag-group';
var FlagContext = /*#__PURE__*/React.createContext(null);

/**
 * useFlags is used to access the `showFlags` function which can be used to programatically display flags.
 * - [Examples](https://atlassian.design/components/flag/flags-provider/examples#using-showflags)
 */
export function useFlags() {
  var api = useContext(FlagContext);
  if (api == null) {
    throw new Error('Unable to find FlagProviderContext');
  }
  return api;
}
var getUniqueId = function () {
  var count = 0;
  return function () {
    return "flag-provider-unique-id:".concat(count++);
  };
}();
export function FlagsProvider(_ref) {
  var children = _ref.children;
  var _useState = useState([]),
    _useState2 = _slicedToArray(_useState, 2),
    flags = _useState2[0],
    setFlags = _useState2[1];
  var removeFlag = useCallback(function (id) {
    setFlags(function (current) {
      return current.slice(0).filter(function (flag) {
        return flag.id !== id;
      });
    });
  }, []);
  var api = useMemo(function () {
    return {
      showFlag: function show(value) {
        var flag = _objectSpread(_objectSpread({}, value), {}, {
          id: value.id || getUniqueId()
        });
        setFlags(function (current) {
          var index = current.findIndex(function (value) {
            return value.id === flag.id;
          });

          // If flag is not found add it
          if (index === -1) {
            return [flag].concat(_toConsumableArray(current));
          }

          // If flag already exists with the same id, then replace it
          var shallow = _toConsumableArray(current);
          shallow[index] = flag;
          return shallow;
        });
        return function dismiss() {
          removeFlag(flag.id);
        };
      }
    };
  }, [removeFlag]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FlagContext.Provider, {
    value: api
  }, children), /*#__PURE__*/React.createElement(FlagGroup, {
    onDismissed: removeFlag
  }, flags.map(function (flag) {
    var isAutoDismiss = flag.isAutoDismiss,
      restProps = _objectWithoutProperties(flag, _excluded);
    var FlagType = isAutoDismiss ? AutoDismissFlag : Flag;
    return /*#__PURE__*/React.createElement(FlagType, _extends({}, restProps, {
      key: flag.id
    }));
  })));
}
export var withFlagsProvider = function withFlagsProvider(fn) {
  return /*#__PURE__*/React.createElement(FlagsProvider, null, fn());
};