import React from 'react';
import { FlagPropsWithoutId } from './types';
type FlagId = string | number;
export type Combine<First, Second> = Omit<First, keyof Second> & Second;
export interface CreateFlagArgs extends FlagPropsWithoutId {
    /**
     * A unique identifier used for rendering and onDismissed callbacks.
     * This will be autogenerated if you don’t supply one.
     * If you don’t want the same flag showing multiple times, provide a unique id.
     */
    id?: FlagId;
    /**
     * Marks whether the flag should render as an AutoDismissFlag
     */
    isAutoDismiss?: boolean;
}
export type FlagArgs = Combine<CreateFlagArgs, {
    id: FlagId;
}>;
export type DismissFn = () => void;
export type FlagAPI = {
    showFlag: (args: CreateFlagArgs) => DismissFn;
};
/**
 * useFlags is used to access the `showFlags` function which can be used to programatically display flags.
 * - [Examples](https://atlassian.design/components/flag/flags-provider/examples#using-showflags)
 */
export declare function useFlags(): FlagAPI;
export declare function FlagsProvider({ children }: {
    children: React.ReactNode;
}): JSX.Element;
export declare const withFlagsProvider: (fn: () => React.ReactNode) => React.ReactNode;
export {};
