"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
/** @jsx jsx */

var BORDER_WIDTH = 2;
var baseFocusOutsideStyles = (0, _react2.css)({
  outline: "".concat(BORDER_WIDTH, "px solid ", "var(--ds-border-focused, #2684FF)"),
  outlineOffset: BORDER_WIDTH
});
var baseInsetStyles = (0, _react2.css)({
  outlineColor: "var(--ds-border-focused, #2684FF)",
  outlineOffset: -BORDER_WIDTH,
  outlineStyle: 'solid',
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  // TODO Delete this comment after verifying space token -> previous value `BORDER_WIDTH`
  outlineWidth: "var(--ds-border-width, 2px)"
});
var focusRingStyles = (0, _react2.css)({
  '&:focus-visible': baseFocusOutsideStyles,
  '@supports not selector(*:focus-visible)': {
    '&:focus': baseFocusOutsideStyles
  },
  '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)': {
    '&:focus-visible': {
      outline: '1px solid'
    }
  }
});
var insetFocusRingStyles = (0, _react2.css)({
  '&:focus-visible': baseInsetStyles,
  '@supports not selector(*:focus-visible)': {
    '&:focus': baseInsetStyles
  },
  '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)': {
    '&:focus-visible': {
      outline: '1px solid',
      outlineOffset: '-1px'
    }
  }
});

/**
 * __Focus ring__
 *
 * A focus ring visually indicates the currently focused item.
 *
 * There are known accessibility issues with this component.
 * Do not use without assistance from the Design System accessibility team.
 *
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/focus-ring)
 *
 * @example
 * ```jsx
 * import FocusRing from '@atlaskit/focus-ring';
 *
 * const InteractiveComponent = () => (
 *   <FocusRing>
 *     <button type="button">Hello</button>
 *   </FocusRing>
 * )
 * ```
 */
var FocusRing = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var children = _ref.children,
    isInset = _ref.isInset,
    focus = _ref.focus;
  var controlledStyles = isInset ? baseInsetStyles : baseFocusOutsideStyles;
  var uncontrolledStyles = isInset ? insetFocusRingStyles : focusRingStyles;
  var focusCls = typeof focus === 'undefined' ? uncontrolledStyles : focus === 'on' && controlledStyles;
  return (0, _react2.jsx)(_react2.ClassNames, null, function (_ref2) {
    var css = _ref2.css,
      cx = _ref2.cx;
    return _react.Children.only(
    // This may look unwieldy but means we skip applying styles / cloning if no className is applicable
    focusCls ?
    /*#__PURE__*/
    // eslint-disable-next-line @repo/internal/react/no-clone-element
    (0, _react.cloneElement)(children, {
      className: cx([css(focusCls), children.props.className])
    }) : children);
  });
});
FocusRing.displayName = 'FocusRing';
var _default = FocusRing;
exports.default = _default;