import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { useRef, useState } from 'react';
/**
 * __Use focus ring__
 *
 * This component has accessibility issues that we are working to resolve.
 * Do not use without support from the Atlassian Design System accessibility team.
 *
 * The useFocusRing hook manages focus in the rare cases where the focus ring’s visual application and the element that takes focus differ.
 * This is not typically a good practice for accessibility, so don’t do this unless you’ve consulted with the accessibility team.
 *
 */
var useFocusRing = function useFocusRing() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'off';
  var _useState = useState(initialState),
    _useState2 = _slicedToArray(_useState, 2),
    focusState = _useState2[0],
    setFocusState = _useState2[1];
  var focusProps = useRef({
    onFocus: function onFocus() {
      return setFocusState('on');
    },
    onBlur: function onBlur() {
      return setFocusState('off');
    }
  });
  return {
    focusState: focusState,
    focusProps: focusProps.current
  };
};
export default useFocusRing;