/** @jsx jsx */
import { FC } from 'react';
import type { FocusRingProps } from './types';
/**
 * __Focus ring__
 *
 * A focus ring visually indicates the currently focused item.
 *
 * There are known accessibility issues with this component.
 * Do not use without assistance from the Design System accessibility team.
 *
 * - [Code](https://atlaskit.atlassian.com/packages/design-system/focus-ring)
 *
 * @example
 * ```jsx
 * import FocusRing from '@atlaskit/focus-ring';
 *
 * const InteractiveComponent = () => (
 *   <FocusRing>
 *     <button type="button">Hello</button>
 *   </FocusRing>
 * )
 * ```
 */
declare const FocusRing: FC<FocusRingProps>;
export default FocusRing;
