"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
/**
 * __Use focus ring__
 *
 * This component has accessibility issues that we are working to resolve.
 * Do not use without support from the Atlassian Design System accessibility team.
 *
 * The useFocusRing hook manages focus in the rare cases where the focus ring’s visual application and the element that takes focus differ.
 * This is not typically a good practice for accessibility, so don’t do this unless you’ve consulted with the accessibility team.
 *
 */
var useFocusRing = function useFocusRing() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'off';
  var _useState = (0, _react.useState)(initialState),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    focusState = _useState2[0],
    setFocusState = _useState2[1];
  var focusProps = (0, _react.useRef)({
    onFocus: function onFocus() {
      return setFocusState('on');
    },
    onBlur: function onBlur() {
      return setFocusState('off');
    }
  });
  return {
    focusState: focusState,
    focusProps: focusProps.current
  };
};
var _default = useFocusRing;
exports.default = _default;