"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Image;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _tokens = require("@atlaskit/tokens");
var _excluded = ["src", "srcDark", "alt", "testId"];
/** @jsx jsx */
var imageStyles = (0, _react2.css)({
  maxWidth: '100%',
  height: 'auto'
});

/**
 * __Image__
 *
 * This component can be used interchangeably with the native `img` element. It includes additional functionality, such as theme support.
 *
 * - [Examples](https://atlassian.design/components/image/examples)
 * - [Code](https://atlassian.design/components/image/code)
 * - [Usage](https://atlassian.design/components/image/usage)
 */
function Image(_ref) {
  var src = _ref.src,
    srcDark = _ref.srcDark,
    alt = _ref.alt,
    testId = _ref.testId,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var imgRef = (0, _react.useRef)(null);
  var _useThemeObserver = (0, _tokens.useThemeObserver)(),
    colorMode = _useThemeObserver.colorMode;
  (0, _react.useEffect)(function () {
    if (imgRef === null || imgRef.current === null) {
      return;
    }
    if (srcDark && colorMode === 'dark') {
      imgRef.current.src = srcDark;
    } else if (src) {
      imgRef.current.src = src;
    }
  }, [src, srcDark, colorMode]);
  return (0, _react2.jsx)("img", (0, _extends2.default)({
    alt: alt,
    css: imageStyles,
    "data-testid": testId,
    src: src,
    ref: imgRef
    // The spread operator is necessary since the component can accept all the props of an `img` element.
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, props));
}