import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { useEffect, useRef } from 'react';
import { css, jsx } from '@emotion/react';
import { useThemeObserver } from '@atlaskit/tokens';
const imageStyles = css({
  maxWidth: '100%',
  height: 'auto'
});

/**
 * __Image__
 *
 * This component can be used interchangeably with the native `img` element. It includes additional functionality, such as theme support.
 *
 * - [Examples](https://atlassian.design/components/image/examples)
 * - [Code](https://atlassian.design/components/image/code)
 * - [Usage](https://atlassian.design/components/image/usage)
 */
export default function Image({
  src,
  srcDark,
  alt,
  testId,
  ...props
}) {
  const imgRef = useRef(null);
  const {
    colorMode
  } = useThemeObserver();
  useEffect(() => {
    if (imgRef === null || imgRef.current === null) {
      return;
    }
    if (srcDark && colorMode === 'dark') {
      imgRef.current.src = srcDark;
    } else if (src) {
      imgRef.current.src = src;
    }
  }, [src, srcDark, colorMode]);
  return jsx("img", _extends({
    alt: alt,
    css: imageStyles,
    "data-testid": testId,
    src: src,
    ref: imgRef
    // The spread operator is necessary since the component can accept all the props of an `img` element.
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, props));
}