/// <reference types="react" />
import { jsx } from '@emotion/react';
interface ImageProps extends React.ImgHTMLAttributes<HTMLImageElement> {
    /**
     * Image URL to use for dark mode. This overrides `src` when the user
     * has selected dark mode either in the app or on their operating system.
     */
    srcDark?: string;
    /**
     * A `testId` prop is provided for specified elements, which is a unique
     * string that appears as a data attribute `data-testid` in the rendered code,
     * serving as a hook for automated tests.
     */
    testId?: string;
}
/**
 * __Image__
 *
 * This component can be used interchangeably with the native `img` element. It includes additional functionality, such as theme support.
 *
 * - [Examples](https://atlassian.design/components/image/examples)
 * - [Code](https://atlassian.design/components/image/code)
 * - [Usage](https://atlassian.design/components/image/usage)
 */
export default function Image({ src, srcDark, alt, testId, ...props }: ImageProps): jsx.JSX.Element;
export {};
