/**
 * Converts the output of Intl.DateTimeFormat.formatToParts of type
 * `[ { type: 'day', value: '17' }, { type: 'month', value: '3' }, ... ]`
 * into an indexed object of type
 * `{ day: '17', month: '3', ... }`
 */
export const toFormattedParts = rawParts => rawParts.reduce((result, datePart) => ({
  ...result,
  [datePart.type]: datePart.value
}), {});