import { DateParser } from '../date-parser';
import { FormattedParts } from './toFormattedParts';
export type DateFormatter = (date: Date) => string;
type WeekDay = 0 | 1 | 2 | 3 | 4 | 5 | 6;
export interface LocalizationProvider {
    getDaysShort: (weekStartDay?: WeekDay) => Array<string>;
    getDaysLong: (weekStartDay?: WeekDay) => Array<string>;
    getMonthsLong: () => Array<string>;
    formatDate: DateFormatter;
    formatTime: DateFormatter;
    parseDate: DateParser;
    formatToParts: (date?: number | Date | undefined) => FormattedParts;
}
export declare const createLocalizationProvider: (locale: string, formatterOptions?: Intl.DateTimeFormatOptions) => LocalizationProvider;
export {};
