"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraAlignIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _constants = require("../constants");
var _utils = require("../utils");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    size = _ref.size,
    iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    iconColor = _ref.iconColor;
  var colors = {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor
  };
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  if (appearance) {
    colors = (0, _utils.getColorsFromAppearance)(appearance);
  }
  return "\n  <svg height=\"32\" viewBox=\"0 0 32 32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n   <defs>\n      <linearGradient id=\"".concat(id, "-1\" x1=\"15.1552\" y1=\"20.5458\" x2=\"16.7055\" y2=\"12.6394\" gradientUnits=\"userSpaceOnUse\">\n        <stop offset=\"0.15\" stop-color=\"").concat(colors.iconGradientStart, "\"  ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " />\n        <stop stop-color=\"").concat(colors.iconGradientStop, "\" offset=\"100%\"></stop>\n      </linearGradient>\n      <linearGradient id=\"").concat(id, "-2\" x1=\"18.3249\" y1=\"10.8472\" x2=\"16.7745\" y2=\"18.7536\" gradientUnits=\"userSpaceOnUse\">\n        <stop offset=\"0.15\" stop-color=\"").concat(colors.iconGradientStart, "\" ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " />\n        <stop stop-color=\"").concat(colors.iconGradientStop, "\" offset=\"100%\"></stop>\n      </linearGradient>\n    </defs>\n    <path fill=\"url(#").concat(id, "-1)\" d=\"M6.93411 5.78784C6.93411 9.51693 9.94886 12.5581 13.6455 12.5581H19.8545V18.8578H26.5659V6.91019C26.5659 6.33091 26.0993 5.82405 25.5251 5.82405L6.93411 5.78784Z\" />\n    <path fill=\"url(#").concat(id, "-2)\" d=\"M26.53 25.5918C26.53 21.8627 23.5152 18.8577 19.8186 18.8577H13.6455V12.5581H6.93411V24.5057C6.93411 25.085 7.40068 25.5918 7.97492 25.5918H26.53Z\" />\n  </svg>");
};

/**
 * __Jira Align icon__
 *
 * The Jira Align icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
var JiraAlignIcon = function JiraAlignIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Jira Align' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor,
    _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto;
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance,
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      iconColor: iconColor,
      size: size
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};
exports.JiraAlignIcon = JiraAlignIcon;