"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _constants = require("../constants");
var _utils = require("../utils");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    size = _ref.size,
    iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    iconColor = _ref.iconColor;
  var colors = {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor
  };
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  if (appearance) {
    colors = (0, _utils.getColorsFromAppearance)(appearance);
  }
  return "\n  <svg viewBox=\"0 0 32 32\" height=\"32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n    <defs>\n      <linearGradient x1=\"94.092%\" x2=\"56.535%\" y1=\"6.033%\" y2=\"43.087%\" id=\"".concat(id, "\">\n        <stop stop-color=\"").concat(colors.iconGradientStart, "\" ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " offset=\"18%\"></stop>\n        <stop stop-color=\"").concat(colors.iconGradientStop, "\" offset=\"100%\"></stop>\n      </linearGradient>\n    </defs>\n    <g stroke=\"none\" stroke-width=\"1\" fill-rule=\"nonzero\">\n      <path fill=\"").concat(colors.iconColor, "\" d=\"M26.0406546,5 L14.9983562,5 C14.9983562,6.32163748 15.5233746,7.58914413 16.4579134,8.52368295 C17.3924523,9.45822178 18.6599589,9.98324022 19.9815964,9.98324022 L22.0151159,9.98324022 L22.0151159,11.9465283 C22.0168782,14.6974491 24.2474348,16.9265768 26.9983562,16.9265762 L26.9983562,5.95770152 C26.9983562,5.42877757 26.5695786,5 26.0406546,5 Z\"></path>\n      <path fill=\"url(#").concat(id, ")\" d=\"M20.0420436,11 L9,11 C9.00176139,13.7504065 11.2309666,15.9796117 13.9813731,15.9813731 L16.0154337,15.9813731 L16.0154337,17.9451836 C16.0154337,19.2671728 16.5405919,20.5350167 17.4753794,21.4698042 C18.4101669,22.4045917 19.6780108,22.9297499 21,22.9297499 L21,11.9579564 C21,11.4288917 20.5711083,11 20.0420436,11 Z\"></path>\n      <path fill=\"url(#").concat(id, ")\" d=\"M14.0420436,17 L3,17 C3.00176275,19.7516528 5.23291286,21.9813736 7.98456626,21.9813731 L10.0250133,21.9813731 L10.0250133,23.9451836 C10.0250082,26.6943468 12.2508419,28.9244664 15,28.9297499 L15,17.9579564 C15,17.4288917 14.5711083,17 14.0420436,17 Z\"></path>\n    </g>\n  </svg>");
};

/**
 * __Jira icon__
 *
 * The Jira icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
var JiraIcon = function JiraIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Jira' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor,
    _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto;
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance,
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      iconColor: iconColor,
      size: size
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};
exports.JiraIcon = JiraIcon;