"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraProductDiscoveryIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _constants = require("../constants");
var _utils = require("../utils");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    size = _ref.size,
    iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    iconColor = _ref.iconColor;
  var colors = {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor
  };
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  if (appearance) {
    colors = (0, _utils.getColorsFromAppearance)(appearance);
  }
  return "\n  <svg\n  height=\"32\"\n  viewBox=\"0 0 32 32\"\n  fill=\"none\"\n  xmlns=\"http://www.w3.org/2000/svg\"\n>\n  <path\n    d=\"M18.9987 15.6133C18.9987 15.6133 19.018 15.9933 19.018 16.518C19.018 18.4727 17.4333 20.0573 15.4787 20.0573C13.524 20.0573 11.9393 18.4727 11.9393 16.518C11.9393 14.5633 13.524 12.9787 15.4787 12.9787C16.0033 12.9787 16.3253 12.998 16.3253 12.998V6.08067C16.046 6.05801 15.764 6.04401 15.4787 6.04401C9.692 6.04401 5.00067 10.7353 5.00067 16.522C5.00067 22.3087 9.692 27 15.4787 27C21.2653 27 25.9567 22.3087 25.9567 16.522C25.9567 16.1887 25.9507 15.9573 25.9233 15.614H18.9987V15.6133Z\"\n    fill=\"url(#".concat(id, ")\"\n  />\n  <path\n    d=\"M17.9233 5.01001C20.8313 5.79601 23.7393 5.79601 26.6473 5.01001C26.8573 4.95334 27.046 5.14201 26.9893 5.35201C26.2033 8.26001 26.2033 11.168 26.9893 14.076C27.046 14.286 26.8573 14.4747 26.6473 14.418C23.7393 13.632 20.8313 13.632 17.9233 14.418C17.7133 14.4747 17.5247 14.286 17.5813 14.076C18.3673 11.168 18.3673 8.26001 17.5813 5.35201C17.5247 5.14201 17.7133 4.95334 17.9233 5.01001Z\"\n    fill=\"").concat(colors.iconColor, "\"\n  />\n  <defs>\n    <linearGradient\n      id=\"").concat(id, "\"\n      x1=\"14.178\"\n      y1=\"17.822\"\n      x2=\"21.4387\"\n      y2=\"10.5613\"\n      gradientUnits=\"userSpaceOnUse\"\n    >\n      <stop stop-color=\"").concat(colors.iconGradientStop, "\" />\n      <stop offset=\"0.927\" stop-color=\"").concat(colors.iconGradientStart, "\" ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " />\n    </linearGradient>\n  </defs>\n</svg>");
};

/**
 * __Jira Product Discovery icon__
 *
 * The Jira Product Discovery icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
var JiraProductDiscoveryIcon = function JiraProductDiscoveryIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Jira Product Discovery' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor;
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance,
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      iconColor: iconColor,
      label: label,
      size: size
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};
exports.JiraProductDiscoveryIcon = JiraProductDiscoveryIcon;