"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraServiceManagementLogo = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _constants = require("../constants");
var _utils = require("../utils");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    iconColor = _ref.iconColor,
    textColor = _ref.textColor;
  var colors = {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor,
    textColor: textColor
  };
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  if (appearance) {
    colors = (0, _utils.getColorsFromAppearance)(appearance);
  }
  return "\n  <svg viewBox=\"0 0 305 32\" height=\"32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n    <defs>\n      <linearGradient x1=\"38.0412357%\" y1=\"6.63683429%\" x2=\"59.8560262%\" y2=\"63.7778713%\" id=\"".concat(id, "\">\n        <stop stop-color=\"").concat(colors.iconGradientStart, "\" ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " offset=\"0%\"></stop>\n        <stop stop-color=\"").concat(colors.iconGradientStop, "\" offset=\"100%\"></stop>\n      </linearGradient>\n    </defs>\n    <g stroke=\"none\" stroke-width=\"1\" fill-rule=\"nonzero\">\n      <path fill=\"url(#").concat(id, ")\" d=\"M11.191 13.448l6.527.026a1.011 1.011 0 01.807 1.623L8.892 27.924a6.81 6.81 0 01-1.387-9.553l3.686-4.923z\"/>\n      <path fill=\"").concat(colors.iconColor, "\" d=\"M7.502 18.372l-6.489-.041a1.011 1.011 0 01-.807-1.623L9.744 4a6.81 6.81 0 011.387 9.553L7.5 18.372z\"/>\n      <path fill=\"").concat(colors.textColor, "\" fill-rule=\"evenodd\" d=\"M38.565 6.004a1.443 1.443 0 011.546 1.545 1.545 1.545 0 11-3.091 0 1.448 1.448 0 011.545-1.545zm-1.133 4.944h2.216v12.88h-2.216v-12.88zm-5.409-4.043h2.318v11.77c0 3.118-1.364 5.27-4.557 5.27a8.253 8.253 0 01-2.784-.44v-2.254a6.496 6.496 0 002.397.44c1.959 0 2.635-1.186 2.635-2.86l-.009-11.926zm10.974 16.922h2.163v-7.599c0-2.728 1.727-3.589 4.56-3.296V10.77c-2.526-.155-3.813.928-4.56 2.447v-2.268h-2.163v12.879zM60.1 21.509c-.822 1.7-2.368 2.576-4.352 2.576-3.425 0-5.152-2.91-5.152-6.698 0-3.63 1.803-6.697 5.41-6.697 1.878 0 3.322.852 4.097 2.526v-2.268h2.216v12.88h-2.216l-.003-2.32zm-3.761.515c1.985 0 3.761-1.262 3.761-4.121v-1.03c0-2.858-1.621-4.122-3.512-4.122-2.497 0-3.785 1.65-3.785 4.636.009 3.089 1.244 4.637 3.536 4.637zm12.985.75c1.311.667 2.83 1.311 6.103 1.311 4.197 0 5.95-1.982 5.986-4.918 0-3.053-2.011-4.2-5.591-5.102-2.989-.746-4.069-1.443-4.069-2.833 0-1.546 1.3-2.318 3.513-2.318a10.4 10.4 0 015.269 1.288V7.883c-1.16-.65-2.728-1.235-5.175-1.235-3.943 0-5.951 1.95-5.951 4.584 0 2.784 1.706 4.095 5.511 5.023 3.22.773 4.148 1.569 4.148 3.065 0 1.495-.963 2.5-3.512 2.5-2.243 0-4.663-.592-6.232-1.417v2.37zm20.94 1.311c-4.817 0-6.928-2.78-6.928-6.733 0-3.89 2.163-6.673 6.077-6.673 3.966 0 5.561 2.757 5.561 6.673v1.016h-9.399c.31 2.19 1.727 3.607 4.766 3.607 1.336-.001 2.662-.237 3.916-.697v2.049c-1.056.553-2.678.758-3.992.758zm-4.715-7.61h7.189c-.129-2.398-1.212-3.762-3.428-3.762-2.344-.012-3.527 1.507-3.761 3.75v.011zm12.057 7.352h2.163v-7.599c0-2.728 1.727-3.589 4.561-3.296V10.77c-2.527-.155-3.815.928-4.56 2.447v-2.268h-2.164v12.879zm12.183 0l-4.997-12.879h2.318l4.172 10.991 4.147-11h2.319l-4.997 12.88-2.962.009zm11.608-17.736a1.441 1.441 0 00-.608-.087 1.45 1.45 0 00-1.458.937 1.45 1.45 0 00-.088.608 1.556 1.556 0 00.428 1.136 1.544 1.544 0 002.233 0 1.557 1.557 0 00.428-1.136 1.449 1.449 0 00-.935-1.458zm.472 4.857h-2.216v12.88h2.216v-12.88zm12.441 12.546c-.773.412-1.956.585-3.141.585-4.584 0-6.733-2.78-6.733-6.733 0-3.89 2.14-6.673 6.733-6.673a6.777 6.777 0 013.064.62v2.05a6.49 6.49 0 00-2.909-.621c-3.349 0-4.716 2.113-4.716 4.613 0 2.5 1.393 4.61 4.766 4.61a8.102 8.102 0 002.927-.465l.009 2.014zm1.762-6.142c0 3.952 2.11 6.733 6.928 6.733 1.306 0 2.927-.205 3.999-.758v-2.05c-1.255.46-2.581.697-3.917.697-3.038 0-4.455-1.416-4.765-3.606h9.396v-1.015c0-3.917-1.595-6.674-5.562-6.674-3.916 0-6.079 2.783-6.079 6.673zm9.402-.878h-7.187l-.008-.011c.231-2.243 1.416-3.762 3.767-3.75 2.216 0 3.299 1.364 3.428 3.761zm12.302-8.178v15.531h-2.318V6.905h4.019l3.838 9.71 1.572 4.663 1.571-4.663 3.861-9.71h3.735v16.922h-2.318V8.474l-1.982 6.106-3.735 9.247h-2.236l-3.688-9.247-2.319-6.284zm24.369 15.789c1.982 0 3.527-.875 4.353-2.576v2.318h2.218v-12.88h-2.215v2.27c-.776-1.675-2.219-2.527-4.098-2.527-3.607 0-5.41 3.068-5.41 6.697 0 3.788 1.724 6.698 5.152 6.698zm4.353-6.182c0 2.86-1.777 4.121-3.762 4.121-2.292 0-3.527-1.548-3.536-4.637 0-2.985 1.288-4.636 3.785-4.636 1.891 0 3.513 1.264 3.513 4.121v1.03zm16.509 5.924h-2.216V16.05c0-2.319-.928-3.349-3.038-3.349-2.049 0-3.478 1.364-3.478 3.966v7.16h-2.216v-12.88h2.216v2.114a4.513 4.513 0 014.069-2.37c2.962 0 4.663 2.048 4.663 5.59v7.546zm7.473.258c1.982 0 3.527-.875 4.353-2.576v2.318h2.224v-12.88h-2.221v2.27c-.776-1.675-2.219-2.527-4.098-2.527-3.607 0-5.41 3.068-5.41 6.697 0 3.788 1.724 6.698 5.152 6.698zm4.353-6.182c0 2.86-1.777 4.121-3.762 4.121-2.292 0-3.527-1.548-3.536-4.637 0-2.985 1.288-4.636 3.785-4.636 1.888 0 3.513 1.264 3.513 4.121v1.03zm14.243 3.606c-.822 1.7-2.368 2.576-4.353 2.576-3.398 0-5.099-2.91-5.099-6.698 0-3.63 1.777-6.697 5.357-6.697 1.882 0 3.322.852 4.098 2.526v-2.268h2.163v11.708c0 3.788-1.777 6.338-6.387 6.338a12.944 12.944 0 01-4.578-.685v-2.164c1.44.496 2.95.756 4.473.77 3.22 0 4.326-1.724 4.326-4.121v-1.285zm-3.758.515c1.981 0 3.758-1.262 3.758-4.121v-1.03c0-2.858-1.622-4.122-3.512-4.122-2.5 0-3.788 1.65-3.788 4.636.011 3.089 1.247 4.637 3.542 4.637zm8.5-4.672c0 3.952 2.111 6.733 6.929 6.733 1.311 0 2.947-.205 3.992-.758v-2.05a11.41 11.41 0 01-3.916.697c-3.039 0-4.455-1.416-4.766-3.606h9.399v-1.015c0-3.917-1.595-6.674-5.561-6.674-3.914 0-6.077 2.783-6.077 6.673zm9.399-.878h-7.186v-.011c.231-2.243 1.417-3.762 3.761-3.75 2.216 0 3.296 1.364 3.425 3.761zm15.819 7.353h-2.216V16.05c0-2.319-.928-3.349-3.042-3.349-2.049 0-3.477 1.364-3.477 3.966v7.16h-2.216v-12.88h2.213v2.114a4.521 4.521 0 014.072-2.37c2.189 0 3.682 1.109 4.326 3.143.72-1.985 2.447-3.144 4.587-3.144 2.883 0 4.481 1.959 4.481 5.591v7.546h-2.216V16.67c0-2.652-.927-3.966-3.041-3.966-2.049 0-3.474 1.364-3.474 3.966l.003 7.157zm11.05-6.475c0 3.952 2.11 6.733 6.928 6.733 1.314 0 2.936-.205 3.993-.758v-2.05a11.4 11.4 0 01-3.917.697c-3.038 0-4.455-1.416-4.765-3.606h9.402v-1.015c0-3.917-1.595-6.674-5.562-6.674-3.916 0-6.079 2.783-6.079 6.673zm9.402-.878h-7.19v-.011c.235-2.243 1.417-3.762 3.762-3.75 2.216 0 3.299 1.364 3.428 3.761zm15.815 7.353h-2.216V16.05c0-2.319-.928-3.349-3.041-3.349-2.049 0-3.475 1.364-3.475 3.966v7.16h-2.216v-12.88h2.216v2.114a4.513 4.513 0 014.069-2.37c2.962 0 4.663 2.048 4.663 5.59v7.546zm9.581-2.265a7.12 7.12 0 01-1.391.181c-1.364 0-2.034-.773-2.046-1.908v-6.838h3.425v-2.05h-3.399V8.22h-2.163v2.74h-2.104v2.049h2.087v6.875c0 2.395 1.34 4.02 4.098 4.02a5.213 5.213 0 001.493-.208v-2.134z\" clip-rule=\"evenodd\"/>\n    </g>\n  </svg>");
};

/**
 * __Jira Service Management logo__
 *
 * The Jira Service Management logo with both the wordmark and the icon combined.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
var JiraServiceManagementLogo = function JiraServiceManagementLogo(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Jira Service Management' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor;
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    appearance: appearance,
    label: label,
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    svg: svg({
      appearance: appearance,
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      iconColor: iconColor,
      textColor: textColor
    }),
    testId: testId,
    textColor: textColor
  });
};
exports.JiraServiceManagementLogo = JiraServiceManagementLogo;