"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpsGenieIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _warnOnce = _interopRequireDefault(require("@atlaskit/ds-lib/warn-once"));
var _constants = require("../constants");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    size = _ref.size;
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  return "\n  <svg viewBox=\"0 0 32 32\" height=\"32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n    <defs>\n      <linearGradient id=\"".concat(id, "-1\" x1=\"50%\" x2=\"50%\" y1=\"0%\" y2=\"100%\">\n        <stop\n          offset=\"0%\"\n          stop-color=\"").concat(iconGradientStop, "\"\n        />\n        <stop\n          offset=\"82%\"\n          stop-color=\"").concat(iconGradientStart, "\"\n          ").concat(iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', "\n        />\n      </linearGradient>\n      <linearGradient id=\"").concat(id, "-2\" x1=\"7.133%\" x2=\"50%\" y1=\"13.352%\" y2=\"58.228%\">\n        <stop\n          offset=\"0%\"\n          stop-color=\"").concat(iconGradientStop, "\"\n        />\n        <stop\n          offset=\"100%\"\n          stop-color=\"").concat(iconGradientStart, "\"\n          ").concat(iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', "\n        />\n      </linearGradient>\n    </defs>\n    <g fill=\"none\" fill-rule=\"evenodd\">\n      <circle cx=\"16\" cy=\"10\" r=\"6\" fill=\"url(#").concat(id, "-1)\" fill-rule=\"nonzero\"/>\n      <path fill=\"url(#").concat(id, "-2)\" fill-rule=\"nonzero\" d=\"M15.4917902,27.8535048 C11.5895108,25.3649677 8.34369777,21.9735337 6.02870456,17.9658651 C5.84991535,17.6419027 5.96743197,17.2343451 6.2912577,17.0553085 L6.31918889,17.0553085 L10.8440409,14.8208136 C11.1613558,14.6649408 11.5451782,14.7822878 11.7210802,15.088953 C14.0054511,18.9171632 17.3801037,21.9767185 21.4132015,23.876104 C19.9238268,25.3786979 18.2733698,26.7125519 16.4917267,27.8535048 C16.1850328,28.0418894 15.7984841,28.0418894 15.4917902,27.8535048 Z\"/>\n      <path fill=\"currentColor\" fill-rule=\"nonzero\" d=\"M16.5084854,27.8535048 C20.4118869,25.3663345 23.6579925,21.9745949 25.971571,17.9658651 C26.1485439,17.6413306 26.0345395,17.23488 25.7146041,17.0497222 L25.6810867,17.0497222 L21.1506484,14.8152274 C20.834975,14.6599316 20.4529644,14.7774733 20.2791954,15.0833668 C17.9924232,18.9191667 14.6087636,21.9817774 10.5647291,23.876104 C12.0560656,25.3787865 13.7083825,26.7126296 15.4917902,27.8535048 C15.802544,28.0488317 16.1977316,28.0488317 16.5084854,27.8535048 Z\"/>\n    </g>\n  </svg>");
};

/**
 * This is the old OpsGenieIcon that was meant to be deprecated but was never removed.
 * This is because it casing it incorrect, it should be Opsgenie, not OpsGenie.
 */
/**
 * @deprecated OpsGenieIcon is incorrectly cased and will be removed from atlaskit/logo in the next major release. Please use OpsgenieIcon (no capital 'g') instead.
 */
var OpsGenieIcon = function OpsGenieIcon(_ref2) {
  var _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor;
  if (typeof process !== 'undefined' && process.env.NODE_ENV !== 'production') {
    (0, _warnOnce.default)('OpsGenieIcon will be renamed to OpsgenieIcon in the next major release. Please use OpsgenieIcon instead.');
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    svg: svg({
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      size: size
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};
exports.OpsGenieIcon = OpsGenieIcon;