"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpsGenieLogo = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _warnOnce = _interopRequireDefault(require("@atlaskit/ds-lib/warn-once"));
var _constants = require("../constants");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    size = _ref.size;
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  return "\n  <svg viewBox=\"0 0 133 32\" height=\"32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n    <defs>\n      <linearGradient id=\"".concat(id, "-1\" x1=\"50%\" x2=\"50%\" y1=\"0%\" y2=\"100%\">\n        <stop\n          offset=\"0%\"\n          stop-color=\"").concat(iconGradientStop, "\"\n        />\n        <stop\n          offset=\"82%\"\n          stop-color=\"").concat(iconGradientStart, "\"\n          ").concat(iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', "\n        />\n      </linearGradient>\n      <linearGradient id=\"").concat(id, "-2\" x1=\"7.133%\" x2=\"50%\" y1=\"13.352%\" y2=\"58.228%\">\n        <stop\n          offset=\"0%\"\n          stop-color=\"").concat(iconGradientStop, "\"\n        />\n        <stop\n          stop-color=\"").concat(iconGradientStart, "\"\n          ").concat(iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', "\n          offset=\"100%\"\n        />\n      </linearGradient>\n    </defs>\n    <g fill-rule=\"evenodd\">\n      <path fill=\"inherit\" fill-rule=\"nonzero\" d=\"M27,14.9963259 C27,9.84140338 29.9575,6.22438088 35.2484675,6.22438088 C40.539435,6.22438088 43.4880625,9.84436088 43.4880625,14.9963259 C43.4880625,20.1985684 40.5305625,23.8422084 35.263255,23.8422084 C29.9959475,23.8422084 27,20.1956109 27,14.9963259 Z M29.34234,14.9963259 C29.34234,18.6133484 31.03403,21.6063384 35.25734,21.6063384 C39.48065,21.6063384 41.1220625,18.6133484 41.1220625,14.9963259 C41.1220625,11.4473259 39.4303725,8.46320838 35.239595,8.46320838 C31.0488175,8.46320838 29.34234,11.4561984 29.34234,14.9963259 Z M48.7050925,21.2928434 L48.7050925,28.6570184 L46.466265,28.6570184 L46.466265,10.5719059 L48.7050925,10.5719059 L48.7050925,12.9142459 C49.53615,11.1959384 51.1006675,10.3116459 53.102895,10.3116459 C56.56317,10.3116459 58.308095,13.2514009 58.308095,17.0754484 C58.308095,20.7457059 56.486275,23.8422084 52.842635,23.8422084 C50.94392,23.8422084 49.4858725,22.9845334 48.7050925,21.2928434 Z M52.50548,12.3937259 C50.500295,12.3937259 48.7050925,13.6684084 48.7050925,16.5578859 L48.7050925,17.5989259 C48.7050925,20.4854459 50.3435475,21.7601284 52.2540925,21.7601284 C54.77684,21.7601284 56.07814,20.0950559 56.07814,17.0754484 C56.0692675,13.9552859 54.8212025,12.3937259 52.50548,12.3937259 Z M64.99796,23.8422084 C63.4334449,23.8787499 61.881995,23.5496237 60.46707,22.8810209 L60.46707,20.5150209 C61.8881071,21.303432 63.4771215,21.740487 65.1014725,21.7897034 C66.81978,21.7897034 67.7040725,21.0887759 67.7040725,20.0713959 C67.7040725,19.0540159 66.94991,18.5098359 64.47744,17.9124209 C61.5879625,17.2085359 60.3635575,16.0906009 60.3635575,13.9582434 C60.3635575,11.6927984 62.1084825,10.3146034 65.074855,10.3146034 C66.5257548,10.2930388 67.96137,10.6131901 69.2656325,11.2491734 L69.2656325,13.5678534 C67.7040725,12.7870734 66.42939,12.3848534 65.0482375,12.3848534 C63.4097825,12.3848534 62.52549,12.9556509 62.52549,13.9730309 C62.52549,14.8839409 63.1495225,15.4517809 65.5450975,16.0284934 C68.4316175,16.7294209 69.889665,17.8029934 69.889665,20.0625234 C69.889665,22.2037534 68.4848525,23.8422084 64.99796,23.8422084 Z M81.7581125,21.2396084 C80.9240975,22.9579159 79.3625375,23.8422084 77.3573525,23.8422084 C73.923695,23.8422084 72.2053875,20.9024534 72.2053875,17.0754484 C72.2053875,13.4081484 74.00059,10.3116459 77.62057,10.3116459 C79.519285,10.3116459 80.9773325,11.1693209 81.76107,12.8610109 L81.76107,10.5719059 L83.9466625,10.5719059 L83.9466625,22.4019059 C83.9466625,26.2289109 82.15146,28.8048934 77.49044,28.8048934 C75.9171438,28.849884 74.3485221,28.6124873 72.858995,28.1039659 L72.858995,25.9154159 C74.315222,26.4191931 75.8431618,26.6848349 77.38397,26.7021109 C80.63722,26.7021109 81.7581125,24.9601434 81.7581125,22.5379509 L81.7581125,21.2396084 Z M77.957725,21.7601284 C79.9599525,21.7601284 81.7581125,20.4854459 81.7581125,17.5989259 L81.7581125,16.5578859 C81.7581125,13.6684084 80.1167,12.3937259 78.2091125,12.3937259 C75.6834075,12.3937259 74.3821075,14.0587984 74.3821075,17.0754484 C74.39098,20.1956109 75.6420025,21.7601284 77.957725,21.7601284 Z M93.5467075,23.8422084 C88.6786625,23.8422084 86.546305,21.0325834 86.546305,17.0399584 C86.546305,13.1094409 88.7318975,10.2998159 92.6890325,10.2998159 C96.696445,10.2998159 98.308282,13.0828234 98.308282,17.0399584 L98.308282,18.0662109 L88.8087925,18.0662109 C89.1222875,20.2784209 90.5537175,21.7098509 93.6236025,21.7098509 C94.9737094,21.7089885 96.313149,21.4707325 97.580737,21.0059659 L97.580737,23.0762159 C96.51308,23.6351834 94.874625,23.8422084 93.5467075,23.8422084 Z M88.7851325,16.1527084 L96.045795,16.1527084 C95.915665,13.7305159 94.82139,12.3523209 92.5825625,12.3523209 C90.2165625,12.3404909 89.0335625,13.8754334 88.7851325,16.1408784 L88.7851325,16.1527084 Z M112.025168,23.5819484 L109.78634,23.5819484 L109.78634,15.7238709 C109.78634,13.3815309 108.848813,12.3404909 106.716455,12.3404909 C104.646205,12.3404909 103.202945,13.7186859 103.202945,16.3479034 L103.202945,23.5819484 L100.964118,23.5819484 L100.964118,10.5689484 L103.202945,10.5689484 L103.202945,12.7013059 C104.015399,11.1952365 105.603045,10.2712035 107.31387,10.3086884 C110.30686,10.3086884 112.025168,12.3789384 112.025168,15.9545559 L112.025168,23.5819484 Z M116.29284,5.57373088 C116.715541,5.54348282 117.130549,5.69826386 117.430208,5.99792296 C117.729867,6.29758207 117.884648,6.71258978 117.8544,7.13529088 C117.8544,7.99771665 117.155266,8.69685088 116.29284,8.69685088 C115.430414,8.69685088 114.73128,7.99771665 114.73128,7.13529088 C114.701032,6.71258978 114.855813,6.29758207 115.155472,5.99792296 C115.455131,5.69826386 115.870139,5.54348282 116.29284,5.57373088 Z M115.148287,10.5719059 L117.387115,10.5719059 L117.387115,23.5849059 L115.148287,23.5849059 L115.148287,10.5719059 Z M127.510637,23.8422084 C122.642592,23.8422084 120.510235,21.0325834 120.510235,17.0399584 C120.510235,13.1094409 122.695827,10.2998159 126.650005,10.2998159 C130.657417,10.2998159 132.269255,13.0828234 132.269255,17.0399584 L132.269255,18.0662109 L122.772722,18.0662109 C123.086217,20.2784209 124.517647,21.7098509 127.587532,21.7098509 C128.937639,21.7089885 130.277079,21.4707325 131.544667,21.0059659 L131.544667,23.0762159 C130.47701,23.6351834 128.838555,23.8422084 127.510637,23.8422084 Z M122.749062,16.1408784 L130.012682,16.1408784 C129.882552,13.7186859 128.788277,12.3404909 126.54945,12.3404909 C124.177535,12.3404909 122.982705,13.8754334 122.749062,16.1408784 Z\"/>\n      <circle cx=\"10.055\" cy=\"10\" r=\"6\" fill=\"url(#").concat(id, "-1)\" fill-rule=\"nonzero\"/>\n      <path fill=\"url(#").concat(id, "-2)\" fill-rule=\"nonzero\" d=\"M9.5466546,27.8535048 C5.6443752,25.3649677 2.39856217,21.9735337 0.0835689575,17.9658651 C-0.0952202525,17.6419027 0.0222963675,17.2343451 0.346122097,17.0553085 L0.374053287,17.0553085 L4.8989053,14.8208136 C5.2162202,14.6649408 5.6000426,14.7822878 5.7759446,15.088953 C8.0603155,18.9171632 11.4349681,21.9767185 15.4680659,23.876104 C13.9786912,25.3786979 12.3282342,26.7125519 10.5465911,27.8535048 C10.2398972,28.0418894 9.8533485,28.0418894 9.5466546,27.8535048 Z\"/>\n      <path fill=\"currentColor\" fill-rule=\"nonzero\" d=\"M10.5633498,27.8535048 C14.4667513,25.3663345 17.7128569,21.9745949 20.0264354,17.9658651 C20.2034083,17.6413306 20.0894039,17.23488 19.7694685,17.0497222 L19.7359511,17.0497222 L15.2055128,14.8152274 C14.8898394,14.6599316 14.5078288,14.7774733 14.3340598,15.0833668 C12.0472876,18.9191667 8.663628,21.9817774 4.6195935,23.876104 C6.11093,25.3787865 7.7632469,26.7126296 9.5466546,27.8535048 C9.8574084,28.0488317 10.252596,28.0488317 10.5633498,27.8535048 Z\"/>\n    </g>\n  </svg>");
};

/**
 * @deprecated OpsGenieLogo is incorrectly cased and will be removed from atlaskit/logo in the next major release. Please use OpsgenieLogo (no capital 'g') instead.
 */
var OpsGenieLogo = function OpsGenieLogo(_ref2) {
  var _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor;
  if (typeof process !== 'undefined' && process.env.NODE_ENV !== 'production') {
    (0, _warnOnce.default)('OpsGenieLogo will be renamed to OpsgenieLogo in the next major release. Please use OpsgenieLogo instead.');
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    svg: svg({
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      size: size
    }),
    testId: testId,
    textColor: textColor
  });
};
exports.OpsGenieLogo = OpsGenieLogo;