"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StrideIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactUid = require("react-uid");
var _warnOnce = _interopRequireDefault(require("@atlaskit/ds-lib/warn-once"));
var _constants = require("../constants");
var _wrapper = _interopRequireDefault(require("../wrapper"));
/* eslint-disable max-len */

var svg = function svg(_ref) {
  var iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop;
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = (0, _reactUid.uid)({
    iconGradientStart: iconGradientStop
  });
  return "\n  <svg viewBox=\"0 0 32 32\" height=\"32\" xmlns=\"http://www.w3.org/2000/svg\" focusable=\"false\" aria-hidden=\"true\">\n    <defs>\n        <linearGradient x1=\"62.272%\" x2=\"15.737%\" y1=\"26.041%\" y2=\"68.741%\" id=\"".concat(id, "\">\n            <stop stop-color=\"").concat(iconGradientStart, "\" ").concat(iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " offset=\"18%\"></stop>\n            <stop stop-color=\"").concat(iconGradientStop, "\" offset=\"100%\"></stop>\n        </linearGradient>\n    </defs>\n    <g stroke=\"none\" stroke-width=\"1\" fill-rule=\"nonzero\">\n      <path fill-rule=\"nonzero\" d=\"M10.6584152,4 L10.6584152,8.39679183 C10.6584152,14.48435 7.60464338,16.8346351 3.71947823,17.1903755 C3.30945638,17.231579 2.99793812,17.5777104 3.00000321,17.9897922 C3.00000321,19.6285964 3.00000321,23.5017703 3.00000321,25.1845425 C2.9996704,25.4044035 3.08990281,25.6146964 3.24947191,25.7659467 C3.40904102,25.9171971 3.62385939,25.9960518 3.84338782,25.9839592 C13.572289,25.4883208 19.4320134,18.3895005 19.4320134,9.57593146 L19.459993,9.57593146 L19.459993,4 L10.6584152,4 Z\" fill=\"url(#").concat(id, ")\"></path>\n      <path fill-rule=\"nonzero\" d=\"M30.1816696,24.829953 L19.8806163,4 L10.6588351,4 L21.5394976,25.3336133 C21.7449071,25.7337742 22.1569759,25.9853368 22.6067778,25.9851739 L29.4741467,25.9851739 C29.7493704,25.982283 30.0037535,25.8380195 30.1475068,25.6033038 C30.29126,25.3685881 30.304166,25.0764302 30.1816696,24.829953 Z\" fill=\"currentColor\"></path>\n    </g>\n  </svg>");
};

/**
 * @deprecated StrideIcon will be removed from atlaskit/logo in the next major release.
 */
var StrideIcon = function StrideIcon(_ref2) {
  var _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? _constants.defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? _constants.defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? _constants.defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? _constants.defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? _constants.defaultLogoParams.textColor : _ref2$textColor;
  if (typeof process !== 'undefined' && process.env.NODE_ENV !== 'production') {
    (0, _warnOnce.default)('StrideIcon has been deprecated and will be removed from @atlaskit/logo in the next major release.');
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.default, {
    svg: svg({
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};
exports.StrideIcon = StrideIcon;