"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorsFromAppearance = void 0;
var _colors = require("@atlaskit/theme/colors");
/* eslint-disable @atlaskit/design-system/ensure-design-token-usage */

// TODO: This is where we need to add tokens for all appearance color values
var getColorsFromAppearance = function getColorsFromAppearance(appearance) {
  var iconGradientStart, iconGradientStop, iconColor, textColor, atlassianLogoTextColor;
  switch (appearance) {
    case 'brand':
      iconGradientStart = _colors.B400;
      iconGradientStop = _colors.B200;
      iconColor = _colors.B200;
      textColor = "var(--ds-text, ".concat(_colors.N800, ")");
      // This is only used for the top level Atlassian wordmark (see AtlassianLogo
      // or AtlassianStartLogo for example), and is only different for the Brand
      // appearance - a bold brand color. For other appearances,
      // atlassianLogoTextColor is the same as textColor.
      atlassianLogoTextColor = _colors.B400;
      break;
    case 'neutral':
      iconGradientStart = _colors.N600;
      iconGradientStop = _colors.N100;
      iconColor = _colors.N100;
      textColor = _colors.N400;
      atlassianLogoTextColor = _colors.N400;
      break;
    case 'inverse':
      iconGradientStart = _colors.N50;
      iconGradientStop = _colors.N0;
      iconColor = _colors.N0;
      textColor = "var(--ds-text-inverse, ".concat(_colors.N0, ")");
      atlassianLogoTextColor = "var(--ds-text-inverse, ".concat(_colors.N0, ")");
      break;
  }
  return {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor,
    textColor: textColor,
    atlassianLogoTextColor: atlassianLogoTextColor
  };
};
exports.getColorsFromAppearance = getColorsFromAppearance;