"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("@emotion/react");
var _constants = require("./constants");
var _excluded = ["label", "svg", "size", "appearance", "iconGradientStart", "iconGradientStop", "iconColor", "textColor", "testId"];
/** @jsx jsx */
var CSS_VAR_COLOR = '--logo-color';
var CSS_VAR_FILL = '--logo-fill';
var baseWrapperStyles = (0, _react.css)({
  display: 'inline-block',
  position: 'relative',
  color: "var(".concat(CSS_VAR_COLOR, ")"),
  fill: "var(".concat(CSS_VAR_FILL, ")"),
  lineHeight: 1,
  userSelect: 'none',
  whiteSpace: 'normal',
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '> svg': {
    height: '100%',
    fill: 'inherit'
  }
});
var stopColorStyles = (0, _react.css)({
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  stop: {
    stopColor: 'currentColor'
  }
});
var sizeStyles = Object.entries(_constants.sizes).reduce(function (acc, _ref) {
  var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
    key = _ref2[0],
    val = _ref2[1];
  acc[key] = (0, _react.css)({
    height: "".concat(val, "px")
  });
  return acc;
}, {});

/**
 * __Wrapper__
 *
 * An internal component used by `@atlaskit/logo` to render logo SVGs with correct styles.
 */
var Wrapper = function Wrapper(_ref3) {
  var _ref4;
  var label = _ref3.label,
    svg = _ref3.svg,
    size = _ref3.size,
    appearance = _ref3.appearance,
    iconGradientStart = _ref3.iconGradientStart,
    iconGradientStop = _ref3.iconGradientStop,
    iconColor = _ref3.iconColor,
    textColor = _ref3.textColor,
    userDefinedTestId = _ref3.testId,
    rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded);
  var shouldApplyStopColor = iconGradientStart === 'inherit' && iconGradientStop === 'inherit' && appearance === undefined;
  var testId = userDefinedTestId && "".concat(userDefinedTestId, "--wrapper");
  return (0, _react.jsx)("span", (0, _extends2.default)({
    css: [baseWrapperStyles, shouldApplyStopColor && stopColorStyles, size && sizeStyles[size]],
    "data-testid": testId,
    style: (_ref4 = {}, (0, _defineProperty2.default)(_ref4, CSS_VAR_COLOR, iconColor), (0, _defineProperty2.default)(_ref4, CSS_VAR_FILL, textColor), _ref4),
    "aria-label": label ? label : undefined,
    role: label ? 'img' : undefined,
    dangerouslySetInnerHTML: {
      __html: svg
    }
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, rest));
};
var _default = Wrapper;
exports.default = _default;