/* eslint-disable max-len */
import React from 'react';
import { defaultLogoParams } from '../constants';
import { getColorsFromAppearance } from '../utils';
import Wrapper from '../wrapper';
const svg = ({
  appearance,
  textColor
}) => {
  let colors = {
    textColor
  };
  if (appearance) {
    colors = getColorsFromAppearance(appearance);
  }
  return `
  <svg height="32" viewBox="0 0 117 32" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
    <g fill="${colors.textColor}">
      <path d="M6.60677 4.66543H9.44207V19.2197C9.44207 23.0574 7.75525 25.7366 3.84325 25.7366C2.37177 25.7366 1.22329 25.4832 0.433716 25.1935V22.4058C1.29507 22.7678 2.33588 22.9488 3.37668 22.9488C5.7813 22.9488 6.60677 21.5006 6.60677 19.4008V4.66543Z" />
      <path d="M14.5743 3.54307C15.6868 3.54307 16.4764 4.23096 16.4764 5.46192C16.4764 6.65668 15.6868 7.38078 14.5743 7.38078C13.4617 7.38078 12.6721 6.69289 12.6721 5.46192C12.6721 4.23096 13.4617 3.54307 14.5743 3.54307ZM13.2104 9.66167H15.9381V25.5918H13.2104V9.66167Z" />
      <path d="M22.7212 25.5918H20.0654V9.66166H22.7212V12.4494C23.6543 10.5668 25.2335 9.22721 28.32 9.40823V12.0874C24.8387 11.7253 22.7212 12.7753 22.7212 16.1785V25.5918Z" />
      <path d="M41.061 22.7316C40.056 24.8315 38.1539 25.9176 35.7134 25.9176C31.5142 25.9176 29.3967 22.3333 29.3967 17.6267C29.3967 13.1373 31.6219 9.33583 36.0364 9.33583C38.3333 9.33583 40.1278 10.3858 41.061 12.4494V9.66167H43.7886V25.5918H41.061V22.7316ZM36.4312 23.3471C38.8717 23.3471 41.0251 21.7903 41.0251 18.2422V16.975C41.0251 13.427 39.0511 11.8702 36.7183 11.8702C33.6676 11.8702 32.0885 13.8976 32.0885 17.5905C32.1244 21.4644 33.6317 23.3471 36.4312 23.3471Z" />
      <path d="M53.9098 20.8852L52.187 25.5918H48.9928L57.1757 4.66543H60.7647L68.9476 25.5918H65.7534L64.0307 20.849C62.1644 21.2472 60.5494 21.4282 58.8984 21.4282C57.2834 21.4282 55.6684 21.211 53.9098 20.8852ZM63.1693 18.4594L58.9702 6.98254L54.7711 18.4956C56.3144 18.7491 57.6064 18.8939 58.8626 18.8939C60.1905 18.8577 61.5543 18.7129 63.1693 18.4594Z" />
      <path d="M75.0487 25.7004C72.4646 25.7004 70.8137 24.4694 70.8137 21.5368V3H73.5413V21.1748C73.5413 22.623 74.4745 23.1298 75.6588 23.1298C75.9459 23.1298 76.1254 23.1298 76.4484 23.0936V25.5556C76.2331 25.628 75.7665 25.7004 75.0487 25.7004Z" />
      <path d="M80.468 3.54307C81.5806 3.54307 82.3702 4.23096 82.3702 5.46192C82.3702 6.65668 81.5806 7.38078 80.468 7.38078C79.3554 7.38078 78.5659 6.69289 78.5659 5.46192C78.5659 4.23096 79.3554 3.54307 80.468 3.54307ZM79.0683 9.66167H81.7959V25.5918H79.0683V9.66167Z" />
      <path d="M96.5468 22.7316C95.5419 24.8315 93.6397 25.9176 91.1992 25.9176C87.036 25.9176 84.9544 22.3333 84.9544 17.6267C84.9544 13.1373 87.1437 9.33583 91.5222 9.33583C93.8192 9.33583 95.6137 10.3858 96.5468 12.4494V9.66167H99.2026V24.1436C99.2026 28.814 97.0134 31.9638 91.3787 31.9638C88.7228 31.9638 87.2872 31.6018 85.7439 31.0949V28.4157C87.4667 28.995 89.297 29.3571 91.2351 29.3571C95.183 29.3571 96.5468 27.221 96.5468 24.2522V22.7316ZM91.917 23.3471C94.3575 23.3471 96.5109 21.7903 96.5109 18.2422V16.975C96.5109 13.427 94.537 11.8702 92.2041 11.8702C89.1535 11.8702 87.5743 13.8976 87.5743 17.5905C87.6102 21.4644 89.1176 23.3471 91.917 23.3471Z" />
      <path d="M116.717 25.5918H113.989V15.9613C113.989 13.1011 112.841 11.834 110.257 11.834C107.744 11.834 105.986 13.5356 105.986 16.7578V25.628H103.258V9.69789H105.986V12.3046C106.991 10.422 108.857 9.37205 110.975 9.37205C114.599 9.37205 116.681 11.9064 116.681 16.2872V25.5918H116.717Z" />
    </g>
  </svg>  
  `;
};

/**
 * __Jira Align wordmark__
 *
 * The Jira Align brand/product name styled as a logo, without an accompanying icon.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export const JiraAlignWordmark = ({
  appearance,
  label = 'Jira Align',
  size = defaultLogoParams.size,
  testId,
  textColor = defaultLogoParams.textColor
}) => {
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    size: size,
    svg: svg({
      appearance,
      textColor
    }),
    testId: testId,
    textColor: textColor
  });
};