import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { sizes } from './constants';
const CSS_VAR_COLOR = '--logo-color';
const CSS_VAR_FILL = '--logo-fill';
const baseWrapperStyles = css({
  display: 'inline-block',
  position: 'relative',
  color: `var(${CSS_VAR_COLOR})`,
  fill: `var(${CSS_VAR_FILL})`,
  lineHeight: 1,
  userSelect: 'none',
  whiteSpace: 'normal',
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  '> svg': {
    height: '100%',
    fill: 'inherit'
  }
});
const stopColorStyles = css({
  // eslint-disable-next-line @repo/internal/styles/no-nested-styles
  stop: {
    stopColor: 'currentColor'
  }
});
const sizeStyles = Object.entries(sizes).reduce((acc, [key, val]) => {
  acc[key] = css({
    height: `${val}px`
  });
  return acc;
}, {});

/**
 * __Wrapper__
 *
 * An internal component used by `@atlaskit/logo` to render logo SVGs with correct styles.
 */
const Wrapper = ({
  label,
  svg,
  size,
  appearance,
  iconGradientStart,
  iconGradientStop,
  iconColor,
  textColor,
  testId: userDefinedTestId,
  ...rest
}) => {
  const shouldApplyStopColor = iconGradientStart === 'inherit' && iconGradientStop === 'inherit' && appearance === undefined;
  const testId = userDefinedTestId && `${userDefinedTestId}--wrapper`;
  return jsx("span", _extends({
    css: [baseWrapperStyles, shouldApplyStopColor && stopColorStyles, size && sizeStyles[size]],
    "data-testid": testId,
    style: {
      [CSS_VAR_COLOR]: iconColor,
      [CSS_VAR_FILL]: textColor
    },
    "aria-label": label ? label : undefined,
    role: label ? 'img' : undefined,
    dangerouslySetInnerHTML: {
      __html: svg
    }
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, rest));
};
export default Wrapper;