/* eslint-disable max-len */
import React from 'react';
import { uid } from 'react-uid';
import { B400 } from '@atlaskit/theme/colors';
import { defaultLogoParams } from '../constants';
import Wrapper from '../wrapper';
var svg = function svg(_ref) {
  var appearance = _ref.appearance;
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = uid({
    appearance: appearance
  });

  // Brand
  var colors = {
    iconGradientStart: '#1D7AFC',
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    iconGradientMid: B400,
    // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
    iconGradientStop: B400
  };
  if (appearance === 'neutral') {
    colors = {
      iconGradientStart: '#758195',
      iconGradientMid: '#596A85',
      iconGradientStop: '#2C3E5D'
    };
  }
  var baseIconContents = "\n   <linearGradient\n    id=\"".concat(id, "-a\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"10.6592\"\n    x2=\"9.74055\"\n    y1=\"28.7353\"\n    y2=\"4.626\"\n  >\n    <stop offset=\".5\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n  </linearGradient>\n  <linearGradient id=\"").concat(id, "-b\">\n    <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientMid, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n  </linearGradient>\n  <linearGradient\n    id=\"").concat(id, "-c\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"28.2733\"\n    x2=\"17.5886\"\n    xlink:href=\"#").concat(id, "-b\"\n    y1=\"17.5235\"\n    y2=\"28.5702\"\n  />\n  <linearGradient\n    id=\"").concat(id, "-d\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"22.0338\"\n    x2=\"22.0338\"\n    y1=\"4.39582\"\n    y2=\"16.4638\"\n  >\n    <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\".59\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n  </linearGradient>\n  <linearGradient\n    id=\"").concat(id, "-e\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"4.04047\"\n    x2=\"21.5118\"\n    y1=\"17.0305\"\n    y2=\"17.0305\"\n  >\n    <stop offset=\".26\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n  </linearGradient>\n  <linearGradient\n    id=\"").concat(id, "-f\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"23.0712\"\n    x2=\"26.8865\"\n    xlink:href=\"#").concat(id, "-b\"\n    y1=\"19.8515\"\n    y2=\"15.7949\"\n  />\n  <linearGradient\n    id=\"").concat(id, "-g\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"18.8126\"\n    x2=\"18.8126\"\n    y1=\"28.5318\"\n    y2=\"5.47314\"\n  >\n    <stop offset=\".36\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n  </linearGradient>\n  <linearGradient\n    id=\"").concat(id, "-h\"\n    gradientUnits=\"userSpaceOnUse\"\n    x1=\"13.0887\"\n    x2=\"13.0887\"\n    y1=\"28.5318\"\n    y2=\"5.48176\"\n  >\n    <stop offset=\".06\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n    <stop offset=\".58\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n    <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStart, "\" />\n  </linearGradient>\n  <path\n    d=\"m15.9999 28.532c-6.65602 0-12.06802-5.412-12.06802-12.068s5.412-12.068 12.06802-12.068v1.92133c-5.5973 0-10.14602 4.54867-10.14602 10.14597 0 5.5974 4.54872 10.146 10.14602 10.146v1.9214z\"\n    fill=\"url(#").concat(id, "-a)\"\n  />\n  <path\n    d=\"m15.9999 28.5322v-1.9214c5.5974 0 10.146-4.5486 10.146-10.146h1.9214c0 6.656-5.412 12.068-12.068 12.068z\"\n    fill=\"url(#").concat(id, "-c)\"\n  />\n  <path\n    d=\"m28.0678 16.4638h-1.9213c0-5.5973-4.5487-10.14598-10.146-10.14598v-1.92134c6.656 0 12.068 5.41201 12.068 12.06802z\"\n    fill=\"url(#").concat(id, "-d)\"\n  />\n  <path\n    d=\"m21.1405 20.1585c-1.2814-.2506-2.2927-.7053-3.9734-1.4666-.464-.204-.9746-.436-1.5593-.696-.3527-.158-.6773-.2974-1.0027-.436-2.534-1.1234-3.9266-1.736-5.63463-1.736-1.19733 0-2.098.3246-2.59933.9373-.34334.4087-.48267.9373-.38067 1.448l-1.88467.362c-.204-1.0767.074-2.1813.78-3.0353.61267-.7427 1.81934-1.634 4.08467-1.634 2.11663 0 3.82463.7613 6.41463 1.9033.3154.1393.6407.288.9934.436.594.26 1.114.492 1.578.7053 1.606.724 2.488 1.1234 3.5553 1.3274z\"\n    fill=\"url(#").concat(id, "-e)\"\n  />\n  <path\n    d=\"m23.0172 20.3442c-.6407 0-1.2534-.056-1.8754-.1853l.3714-1.8847c.5013.102.9933.1487 1.504.1487 1.188 0 2.0886-.2974 2.6086-.8634s.5387-1.2533.5107-1.6153l1.912-.1673c.102 1.1693-.2507 2.2653-1.0027 3.082-.622.6773-1.8193 1.4853-4.0286 1.4853z\"\n    fill=\"url(#").concat(id, "-f)\"\n  />\n  <path\n    d=\"m16 28.5318v-1.9213c2.7573 0 4.4-2.8127 4.4-7.5194 0-4.7066-1.6707-8.652-5.096-12.29996l1.402-1.318c3.778 4.01934 5.616 8.47536 5.616 13.61796 0 5.8207-2.4227 9.4407-6.322 9.4407z\"\n    fill=\"url(#").concat(id, "-g)\"\n  />\n  <path\n    d=\"m15.9987 28.5318c-4.1494 0-6.52604-3.3787-6.52604-9.2734 0-6.8786 3.00804-10.72198 5.82064-13.77598l1.4114 1.29934c-3.2767 3.56464-5.31 6.88804-5.31 12.47604 0 6.08 2.5066 7.352 4.6046 7.352v1.9213z\"\n    fill=\"url(#").concat(id, "-h)\"\n  />\n  <g fill=\"").concat(colors.iconGradientStart, "\">\n    <path\n      d=\"m10.8565 17.4665c1.2407 0 2.2467-1.006 2.2467-2.2467s-1.006-2.2467-2.2467-2.2467c-1.24064 0-2.24664 1.006-2.24664 2.2467s1.006 2.2467 2.24664 2.2467z\"\n    />\n    <path\n      d=\"m21.2418 21.3381c1.2407 0 2.2467-1.006 2.2467-2.2467s-1.006-2.2467-2.2467-2.2467-2.2467 1.006-2.2467 2.2467 1.006 2.2467 2.2467 2.2467z\"\n    />\n    <path\n      d=\"m15.9979 7.96062c1.2407 0 2.2467-1.006 2.2467-2.24667 0-1.24066-1.006-2.24666-2.2467-2.24666s-2.2467 1.006-2.2467 2.24666c0 1.24067 1.006 2.24667 2.2467 2.24667z\"\n    />\n  </g>");

  /**
   * inverse icons use transparency to achieve a certain gradient effect, requiring a different SVG structure
   */
  var inverseIconContents = "\n    <linearGradient id=\"".concat(id, "-inverse-a\" gradientUnits=\"userSpaceOnUse\" x1=\"13.1575\" x2=\"8.62613\" y1=\"25.3248\"\n    y2=\"5.13609\">\n    <stop offset=\"0\" stop-color=\"#fff\" />\n    <stop offset=\".17\" stop-color=\"#fff\" stop-opacity=\".91\" />\n    <stop offset=\".5\" stop-color=\"#fff\" stop-opacity=\".74\" />\n    <stop offset=\".76\" stop-color=\"#fff\" stop-opacity=\".64\" />\n    <stop offset=\".92\" stop-color=\"#fff\" stop-opacity=\".6\" />\n  </linearGradient>\n  <linearGradient id=\"").concat(id, "-inverse-b\">\n    <stop offset=\"0\" stop-color=\"#fff\" />\n    <stop offset=\".18\" stop-color=\"#fff\" stop-opacity=\".91\" />\n    <stop offset=\".55\" stop-color=\"#fff\" stop-opacity=\".74\" />\n    <stop offset=\".83\" stop-color=\"#fff\" stop-opacity=\".64\" />\n    <stop offset=\"1\" stop-color=\"#fff\" stop-opacity=\".6\" />\n  </linearGradient>\n  <linearGradient id=\"").concat(id, "-inverse-c\" gradientUnits=\"userSpaceOnUse\" x1=\"10.6926\" x2=\"20.4159\" xlink:href=\"#").concat(id, "-inverse-b\"\n    y1=\"15.0061\" y2=\"18.9068\" />\n  <linearGradient id=\"").concat(id, "-inverse-d\" gradientUnits=\"userSpaceOnUse\" x1=\"22.7236\" x2=\"20.8289\" xlink:href=\"#").concat(id, "-inverse-b\"\n    y1=\"3.59276\" y2=\"23.2521\" />\n  <linearGradient id=\"").concat(id, "-inverse-e\" gradientUnits=\"userSpaceOnUse\" x1=\"18.8186\" x2=\"18.8186\" y1=\"28.5366\"\n    y2=\"5.46924\">    <stop offset=\".1\" stop-color=\"#fff\" />\n    <stop offset=\".27\" stop-color=\"#fff\" stop-opacity=\".91\" />\n    <stop offset=\".59\" stop-color=\"#fff\" stop-opacity=\".74\" />\n    <stop offset=\".85\" stop-color=\"#fff\" stop-opacity=\".64\" />\n    <stop offset=\"1\" stop-color=\"#fff\" stop-opacity=\".6\" />\n  </linearGradient>\n  <linearGradient id=\"").concat(id, "-inverse-f\" gradientUnits=\"userSpaceOnUse\" x1=\"12.5694\" x2=\"13.9441\" y1=\"5.09736\"\n    y2=\"26.7354\">\n    <stop offset=\".03\" stop-color=\"#fff\" />\n    <stop offset=\".1\" stop-color=\"#fff\" stop-opacity=\".9\" />\n    <stop offset=\".29\" stop-color=\"#fff\" stop-opacity=\".68\" />\n    <stop offset=\".38\" stop-color=\"#fff\" stop-opacity=\".6\" />\n    <stop offset=\".59\" stop-color=\"#fff\" stop-opacity=\".6\" />\n    <stop offset=\".65\" stop-color=\"#fff\" stop-opacity=\".65\" />\n    <stop offset=\".76\" stop-color=\"#fff\" stop-opacity=\".77\" />\n    <stop offset=\".91\" stop-color=\"#fff\" stop-opacity=\".96\" />\n    <stop offset=\".94\" stop-color=\"#fff\" />\n  </linearGradient>\n  <path\n    d=\"m16.0048 6.31409v-1.922c-6.65867 0-12.07267 5.414-12.07267 12.07201 0 .6873.06533 1.356.16733 2.0153 0 .028 0 .0654.00934.0927 1.00266 5.6553 5.9433 9.9647 11.8867 9.9647v-1.922c-5.0334 0-9.22137-3.6774-10.0107-8.488-.06534-.4827.074-.9754.39-1.3654.50133-.6126 1.402-.938 2.6-.938.63133 0 1.226.0834 1.848.2507v-1.9687c-.6033-.13-1.20734-.1953-1.848-.1953-1.30934 0-2.266.2973-2.95334.6967.882-4.71738 5.02404-8.29271 9.98264-8.29271z\"\n    fill=\"url(#").concat(id, "-inverse-a)\" />\n  <path\n    d=\"m17.9639 16.9475c-.464-.204-.9847-.446-1.5787-.706-.3433-.1487-.678-.2974-.9933-.4367-1.8013-.7987-3.1853-1.4113-4.5687-1.6993v1.9686c1.0494.2787 2.1914.78 3.7887 1.486.316.1394.65.288 1.0027.4367.5853.26 1.1053.492 1.56.6967 1.6806.752 2.6933 1.2073 3.9746 1.4673l.3714-1.8853c-1.068-.2134-1.95-.6034-3.5567-1.328z\"\n    fill=\"url(#").concat(id, "-inverse-c)\" />\n  <path\n    d=\"m28.0683 16.2508v-.4734c-.3714-6.34264-5.6367-11.38531-12.0634-11.38531v1.922c5.5254 0 10.0294 4.42931 10.1407 9.92731-.0093.3807-.1207.882-.52 1.3187-.52.5667-1.4207.8633-2.6093.8633-.5107 0-1.0027-.0466-1.5047-.1486l-.3713 1.8853c.622.1207 1.2353.186 1.876.186 1.0586 0 1.8946-.186 2.5353-.464-1.402 3.9187-5.1633 6.7327-9.556 6.7327v1.922c6.6587 0 12.0727-5.414 12.0727-12.0727 0-.074 0-.1393 0-.2133z\"\n    fill=\"url(#").concat(id, "-inverse-d)\" />\n  <path\n    d=\"m16.0046 28.5366v-1.922c2.758 0 4.402-2.814 4.402-7.522s-1.6713-8.6554-5.098-12.3047l1.402-1.31866c3.7793 4.02133 5.618 8.47866 5.618 13.62336 0 5.8226-2.424 9.4446-6.324 9.4446z\"\n    fill=\"url(#").concat(id, "-inverse-e)\" />\n  <path\n    d=\"m16.0047 28.5367c-4.1513 0-6.52863-3.38-6.52863-9.2773 0-6.8814 3.00863-10.72604 5.82263-13.78137l1.4114 1.3c-3.278 3.56597-5.312 6.89067-5.312 12.48137 0 6.0826 2.5073 7.3546 4.606 7.3546v1.922z\"\n    fill=\"url(#").concat(id, "-inverse-f)\" />\n  <g fill=\"#fff\">\n    <path\n      d=\"m10.8601 17.4673c1.2412 0 2.2474-1.0061 2.2474-2.2473s-1.0062-2.2473-2.2474-2.2473c-1.24114 0-2.24731 1.0061-2.24731 2.2473s1.00617 2.2473 2.24731 2.2473z\" />\n    <path\n      d=\"m21.2512 21.3399c1.2412 0 2.2474-1.0062 2.2474-2.2474 0-1.2411-1.0062-2.2473-2.2474-2.2473-1.2411 0-2.2473 1.0062-2.2473 2.2473 0 1.2412 1.0062 2.2474 2.2473 2.2474z\" />\n    <path\n      d=\"m16.0047 7.95805c1.2411 0 2.2473-1.00617 2.2473-2.24734s-1.0062-2.24733-2.2473-2.24733c-1.2412 0-2.2474 1.00616-2.2474 2.24733s1.0062 2.24734 2.2474 2.24734z\" />\n  </g>");
  return "<svg\n  fill=\"none\"\n  height=\"32\"\n  viewBox=\"0 0 32 32\"\n  width=\"32\"\n  xmlns=\"http://www.w3.org/2000/svg\"\n  xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n>\n  ".concat(appearance === 'inverse' ? inverseIconContents : baseIconContents, "\n</svg>");
};

/**
 * __Atlas logo__
 *
 * The Atlas icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export var AtlasIcon = function AtlasIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Atlas' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId;
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance
    }),
    size: size,
    testId: testId
  });
};