/* eslint-disable max-len */
import React from 'react';
import { uid } from 'react-uid';
import { defaultLogoParams } from '../constants';
import { getColorsFromAppearance } from '../utils';
import Wrapper from '../wrapper';
var svg = function svg(_ref) {
  var appearance = _ref.appearance;
  // Replace with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = uid({
    appearance: appearance
  });
  var colors = getColorsFromAppearance(appearance);
  return "<svg height=\"32\" viewBox=\"0 0 48 48\" xmlns=\"http://www.w3.org/2000/svg\">\n  <defs>\n    <linearGradient id=\"".concat(id, "-a\" x1=\"12.595\" x2=\"12.595\" y1=\"40\" y2=\"30\" gradientUnits=\"userSpaceOnUse\">\n      <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientStart, "\"/>\n      <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\"/>\n    </linearGradient>\n    <linearGradient id=\"").concat(id, "-b\" x1=\"28.595\" x2=\"28.595\" y1=\"40\" y2=\"27\" gradientUnits=\"userSpaceOnUse\">\n      <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientStart, "\"/>\n      <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\"/>\n    </linearGradient>\n    <linearGradient xlink:href=\"#").concat(id, "-b\" id=\"").concat(id, "-c\" x1=\"20.595\" x2=\"20.595\" y2=\"22\"/>\n    <linearGradient xlink:href=\"#").concat(id, "-b\" id=\"").concat(id, "-d\" x1=\"36.595\" x2=\"36.595\" y2=\"20\"/>\n  </defs>\n  <path d=\"M10.595 30h4v10h-4z\" fill=\"url(#").concat(id, "-a)\"/>\n  <path d=\"M26.595 27h4v13h-4z\" fill=\"url(#").concat(id, "-b)\"/>\n  <path d=\"M18.595 22h4v18h-4z\" fill=\"url(#").concat(id, "-c)\"/>\n  <path d=\"M34.595 20h4v20h-4z\" fill=\"url(#").concat(id, "-d)\"/>\n  <path fill=\"").concat(colors.iconColor, "\" d=\"m9.009 25.414-2.828-2.828 10.127-10.128a5 5 0 0 1 6.605-.411l4.471 3.477a1.5 1.5 0 0 0 1.982-.123l9.815-9.815 2.828 2.828-10.127 10.128a5 5 0 0 1-6.605.411l-4.471-3.477a1.5 1.5 0 0 0-1.982.123l-9.815 9.815Z\" />\n</svg>");
};

/**
 * __Atlassian Analytics icon__
 *
 * The Atlassian Analytics icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export var AtlassianAnalyticsIcon = function AtlassianAnalyticsIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Atlassian Analytics' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId;
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance
    }),
    size: size,
    testId: testId
  });
};