/* eslint-disable max-len */
import React from 'react';
import { uid } from 'react-uid';
import { defaultLogoParams } from '../constants';
import { getColorsFromAppearance } from '../utils';
import Wrapper from '../wrapper';
var svg = function svg(_ref) {
  var appearance = _ref.appearance;
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = uid({
    appearance: appearance
  });
  var colors = getColorsFromAppearance(appearance);
  return "\n  <svg height=\"32\" viewBox=\"0 0 477 48\" xmlns=\"http://www.w3.org/2000/svg\">\n  <defs>\n    <linearGradient id=\"".concat(id, "-a\" x1=\"447.285\" x2=\"447.285\" y1=\"40\" y2=\"30\" gradientUnits=\"userSpaceOnUse\">\n      <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientStart, "\"/>\n      <stop offset=\"1\" stop-color=\"").concat(colors.iconGradientStop, "\"/>\n    </linearGradient>\n    <linearGradient xlink:href=\"#").concat(id, "-a\" id=\"").concat(id, "-b\" x1=\"463.285\" x2=\"463.285\" y2=\"27\"/>\n    <linearGradient xlink:href=\"#").concat(id, "-a\" id=\"").concat(id, "-c\" x1=\"455.285\" x2=\"455.285\" y2=\"22\"/>\n    <linearGradient xlink:href=\"#").concat(id, "-a\" id=\"").concat(id, "-d\" x1=\"471.285\" x2=\"471.285\" y2=\"20\"/>\n  </defs>\n  <g fill=\"").concat(colors.atlassianLogoTextColor, "\">\n    <path d=\"M106.72 18.359c0 4.201 1.949 7.536 9.572 9.008 4.548.953 5.5 1.689 5.5 3.205 0 1.473-.953 2.425-4.158 2.425-3.725 0-8.142-1.256-11.044-2.988v6.843c2.295 1.126 5.327 2.382 10.957 2.382 7.969 0 11.131-3.551 11.131-8.835m0 0c0-4.981-2.642-7.319-10.091-8.922-4.114-.91-5.111-1.819-5.111-3.118 0-1.646 1.473-2.339 4.201-2.339 3.292 0 6.54.996 9.615 2.382v-6.54c-2.166-1.083-5.5-1.949-9.398-1.949-7.363 0-11.174 3.205-11.174 8.445M209.1 10.346v28.455h6.063V17.103l2.556 5.76 8.575 15.938h7.623V10.346h-6.064V28.71l-2.295-5.327-6.886-13.037H209.1zM163.909 10.346h6.626v28.455h-6.626zM156.263 30.399c0-4.981-2.642-7.319-10.091-8.922-4.114-.91-5.111-1.819-5.111-3.118 0-1.646 1.473-2.339 4.201-2.339 3.292 0 6.54.996 9.615 2.382v-6.54c-2.166-1.083-5.5-1.949-9.398-1.949-7.363 0-11.174 3.205-11.174 8.445 0 4.201 1.949 7.536 9.572 9.008 4.548.953 5.5 1.689 5.5 3.205 0 1.473-.953 2.425-4.158 2.425-3.725 0-8.142-1.256-11.044-2.988v6.843c2.295 1.126 5.327 2.382 10.957 2.382 7.969 0 11.131-3.551 11.131-8.835M55.243 10.346v28.455h13.62l2.145-6.15h-9.095V10.346h-6.67zM28.334 10.346v6.15h7.363v22.305h6.67V16.496h7.882v-6.15H28.334zM18.663 10.346h-8.74L0 38.801h7.579l1.407-4.792a18.852 18.852 0 0 0 10.612 0l1.407 4.792h7.579l-9.922-28.455Zm-4.37 18.533c-1.267 0-2.49-.185-3.647-.524l3.647-12.422 3.647 12.422c-1.157.339-2.38.524-3.647.524ZM92.344 10.346h-8.74l-9.922 28.455h7.579l1.407-4.792a18.852 18.852 0 0 0 10.612 0l1.407 4.792h7.579l-9.922-28.455Zm-4.37 18.533c-1.267 0-2.49-.185-3.647-.524l3.647-12.422 3.647 12.422c-1.157.339-2.38.524-3.647.524ZM194.414 10.346h-8.74l-9.922 28.455h7.579l1.407-4.792a18.852 18.852 0 0 0 10.612 0l1.407 4.792h7.579l-9.922-28.455Zm-4.37 18.533c-1.267 0-2.49-.185-3.647-.524l3.647-12.422 3.647 12.422c-1.157.339-2.38.524-3.647.524Z\"/>\n  </g>\n  <g fill=\"").concat(colors.textColor, "\">\n    <path d=\"m254.776 31.987-2.53 6.809H247.6l11.916-30.225h5.244l11.916 30.225h-4.646l-2.53-6.855c-2.714.552-5.061.828-7.499.828-2.3 0-4.646-.276-7.223-.782Zm13.479-3.496-6.119-16.562-6.119 16.608c2.254.368 4.141.552 5.98.552 1.933 0 3.911-.23 6.257-.598ZM298.984 38.796h-3.957V24.902c0-4.141-1.656-5.981-5.428-5.981-3.681 0-6.211 2.438-6.211 7.085v12.79h-3.957V15.794h3.957v3.772c1.472-2.715 4.187-4.232 7.269-4.232 5.291 0 8.327 3.634 8.327 9.983v13.479ZM320.097 34.656c-1.472 3.036-4.232 4.6-7.775 4.6-6.119 0-9.201-5.199-9.201-11.961 0-6.486 3.22-11.961 9.661-11.961 3.358 0 5.935 1.518 7.314 4.508v-4.048h3.957v23.002h-3.957v-4.14Zm-6.717.92c3.542 0 6.717-2.254 6.717-7.361v-1.84c0-5.106-2.898-7.361-6.256-7.361-4.463 0-6.763 2.944-6.763 8.281 0 5.521 2.208 8.281 6.303 8.281ZM336.196 38.935c-3.772 0-6.165-1.794-6.165-6.027V6.179h3.957v26.269c0 2.07 1.38 2.806 3.083 2.806.414 0 .69 0 1.15-.046v3.542c-.322.092-1.012.184-2.024.184ZM347.328 37.324l-8.327-21.53h4.232l7.361 19.69 7.361-19.69h4.232l-8.695 22.267c-2.576 6.579-4.048 9.983-9.891 9.983-1.979 0-3.083-.184-4.232-.644v-3.404c1.334.414 2.852.552 4.002.552 3.22 0 4.646-2.208 6.533-7.223h-2.576ZM374.698 35.07c.92 0 1.794-.185 2.484-.322v3.818c-.69.184-1.472.368-2.668.368-4.923 0-7.315-2.898-7.315-7.177V19.473h-3.727v-3.68h3.727v-4.877h3.864v4.877h6.119v3.68h-6.119v12.191c0 2.024 1.196 3.405 3.635 3.405ZM384.265 6.961c1.61 0 2.76 1.012 2.76 2.76s-1.15 2.76-2.76 2.76-2.76-1.012-2.76-2.76 1.15-2.76 2.76-2.76Zm-2.024 8.833h3.957v23.002h-3.957V15.794ZM408.416 38.198c-1.38.736-3.496 1.058-5.612 1.058-8.189 0-12.007-4.968-12.007-12.007 0-6.947 3.818-11.915 12.007-11.915 2.07 0 3.68.276 5.475 1.104v3.681c-1.472-.69-3.037-1.104-5.199-1.104-5.98 0-8.419 3.772-8.419 8.235s2.484 8.235 8.511 8.235c2.346 0 3.818-.322 5.244-.828v3.542ZM420.144 39.256c-3.451 0-6.257-.782-8.005-1.702v-4.187c1.978 1.15 5.291 2.254 8.188 2.254 3.037 0 4.601-1.242 4.601-3.036 0-1.749-1.334-2.761-5.705-3.818-5.106-1.242-7.269-3.221-7.269-6.993 0-4.002 3.082-6.44 8.327-6.44 2.99 0 5.705.736 7.407 1.656v4.094c-2.76-1.38-5.014-2.117-7.453-2.117-2.898 0-4.462 1.013-4.462 2.807 0 1.61 1.104 2.622 5.336 3.635 5.106 1.242 7.683 3.128 7.683 7.13 0 3.819-2.484 6.717-8.649 6.717Z\"/>\n  </g>\n  <path fill=\"url(#").concat(id, "-a)\" d=\"M445.285 30h4v10h-4z\"/>\n  <path fill=\"url(#").concat(id, "-b)\" d=\"M461.285 27h4v13h-4z\"/>\n  <path fill=\"url(#").concat(id, "-c)\" d=\"M453.285 22h4v18h-4z\"/>\n  <path fill=\"url(#").concat(id, "-d)\" d=\"M469.285 20h4v20h-4z\"/>\n  <path fill=\"").concat(colors.iconColor, "\" d=\"m443.699 25.414-2.828-2.828 10.127-10.128a5 5 0 0 1 6.605-.411l4.471 3.477a1.5 1.5 0 0 0 1.982-.123l9.815-9.815 2.828 2.828-10.127 10.128a5 5 0 0 1-6.605.411l-4.471-3.477a1.5 1.5 0 0 0-1.982.123l-9.815 9.815Z\"/>\n</svg>");
};

/**
 * __Atlassian Analytics logo__
 *
 * The Atlassian Analytics logo with both the wordmark and the icon combined.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export var AtlassianAnalyticsLogo = function AtlassianAnalyticsLogo(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Atlassian Analytics' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId;
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    size: size,
    svg: svg({
      appearance: appearance
    }),
    testId: testId
  });
};