/* eslint-disable max-len */
import React from 'react';
import { defaultLogoParams } from '../constants';
import { getColorsFromAppearance } from '../utils';
import Wrapper from '../wrapper';
var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    textColor = _ref.textColor;
  var colors = {
    textColor: textColor
  };
  if (appearance) {
    colors = getColorsFromAppearance(appearance);
  }
  return "\n  <svg\n    fill=\"none\"\n    height=\"32\"\n    viewBox=\"0 0 110 32\"\n    xmlns=\"http://www.w3.org/2000/svg\"\n    focusable=\"false\"\n    aria-hidden=\"true\"\n  >\n    <path\n      clip-rule=\"evenodd\"\n      d=\"m14.1286 22.6255c-1.1334.7472-2.9292 1.0769-4.80982 1.0769-5.95893 0-9.31829172-3.5917-9.31829172-9.3089 0-5.50998 3.35936172-9.39365 9.27120172-9.39365 1.76761 0 3.53521.31396 4.83491 1.25583v2.40179c-1.2997-.82885-2.7345-1.25584-4.83491-1.25584-4.25414 0-6.79721 2.82567-6.79721 6.99187s2.6247 6.9353 6.94477 6.9353c1.63605.0146 3.25155-.3656 4.70935-1.1082zm2.2985-6.1319c0-4.1442 2.4301-7.15821 6.5743-7.15821 4.1443 0 6.5115 3.00141 6.5115 7.15821 0 4.1569-2.4049 7.2211-6.5209 7.2211s-6.5649-3.0799-6.5649-7.2211zm2.3202 0c0 2.6247 1.2998 4.9983 4.2541 4.9983 2.9544 0 4.2008-2.3736 4.2008-4.9983s-1.2559-4.9479-4.2008-4.9479-4.2541 2.3232-4.2541 4.9479zm22.9025 6.9327h2.3767v-7.6794c0-2.7911 1.5321-4.2541 3.7298-4.2541 2.2636 0 3.2589 1.4096 3.2589 4.2541v7.6794h2.3767v-8.0938c0-3.8962-1.7143-5.99663-4.8067-5.99663-2.2919 0-4.1443 1.24323-4.9166 3.37193-.6907-2.182-2.2951-3.37193-4.6435-3.37193-.8909-.01851-1.7697.2091-2.5397.65777-.7699.44866-1.4012 1.10106-1.8243 1.88526v-2.26675h-2.3767v13.81415h2.3767v-7.6794c0-2.7911 1.5321-4.2541 3.7298-4.2541 2.2637 0 3.2589 1.1051 3.2589 3.5917zm18.0023-2.4305v7.8176h-2.3767v-19.20173h2.3767v2.48653c.8853-1.8209 2.543-2.76281 4.6685-2.76281 3.6733 0 5.5257 3.13961 5.5257 7.18341 0 3.8962-1.934 7.1833-5.802 7.1833-2.0313 0-3.5791-.9104-4.3922-2.7063zm4.0266-9.4501c-2.1474.0032-4.0266 1.3599-4.0266 4.4205v1.1051c0 3.0674 1.7393 4.4206 3.7675 4.4206 2.678 0 4.0594-1.7676 4.0594-4.9731-.025-3.3118-1.3471-4.9695-3.8003-4.9731zm13.612 12.1564c2.1286 0 3.7863-.9387 4.6686-2.7628l.0031 2.4866h2.3767v-13.81423h-2.3767v2.43323c-.832-1.7959-2.3798-2.70951-4.3954-2.70951-3.868 0-5.802 3.29031-5.802 7.18341 0 4.0626 1.8524 7.1833 5.5257 7.1833zm4.6686-6.6308c0 3.0674-1.9058 4.4206-4.0344 4.4206-2.4583 0-3.7832-1.6577-3.7926-4.9731 0-3.2024 1.3814-4.9731 4.0594-4.9731 2.0282 0 3.7676 1.3563 3.7676 4.4205zm10.307 6.6313c-1.6596.0437-3.3065-.3003-4.8099-1.0047v-2.5116c1.5084.8373 3.1954 1.3012 4.9198 1.3531 1.8241 0 2.7628-.7472 2.7628-1.8241 0-1.0768-.8037-1.6577-3.4253-2.2919-3.0674-.7472-4.3671-1.934-4.3671-4.2007 0-2.4018 1.8523-3.86801 5.0013-3.86801 1.5405-.02191 3.0645.31903 4.4488.99521v2.4583c-1.6577-.8288-3.0108-1.2558-4.477-1.2558-1.7394 0-2.6781.6059-2.6781 1.6828 0 .967.6625 1.5698 3.2024 2.1977 3.0674.7441 4.6152 1.8838 4.6152 4.2793 0 2.2511-1.4913 3.9904-5.1929 3.9904zm7.4606-1.0047c1.5071.7075 3.1581 1.0516 4.8221 1.0047 3.686 0 5.178-1.7393 5.178-3.9904 0-2.3955-1.548-3.5352-4.613-4.2793-2.543-.6279-3.205-1.2307-3.205-2.1977 0-1.0769.939-1.6828 2.678-1.6828 1.466 0 2.819.427 4.477 1.2558v-2.4583c-1.384-.67618-2.908-1.01712-4.449-.99521-3.149 0-5.0011 1.46621-5.0011 3.86801 0 2.2667 1.3001 3.4535 4.3671 4.2007 2.625.6342 3.425 1.2151 3.425 2.2919 0 1.0769-.938 1.8241-2.762 1.8241-1.724-.0517-3.41-.5158-4.9171-1.3531z\"\n      fill=\"".concat(colors.textColor, "\"\n      fill-rule=\"evenodd\"\n    />\n  </svg>");
};

/**
 * __Compass wordmark__
 *
 * The Compass brand/product name styled as a logo, without an accompanying icon.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export var CompassWordmark = function CompassWordmark(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Compass' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? defaultLogoParams.textColor : _ref2$textColor;
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    size: size,
    svg: svg({
      appearance: appearance,
      textColor: textColor
    }),
    testId: testId,
    textColor: textColor
  });
};