/* eslint-disable max-len */
import React from 'react';
import { uid } from 'react-uid';
import { defaultLogoParams } from '../constants';
import { getColorsFromAppearance } from '../utils';
import Wrapper from '../wrapper';
var svg = function svg(_ref) {
  var appearance = _ref.appearance,
    iconGradientStart = _ref.iconGradientStart,
    iconGradientStop = _ref.iconGradientStop,
    iconColor = _ref.iconColor;
  var colors = {
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    iconColor: iconColor
  };
  // Will be fixed upon removal of deprecated iconGradientStart and
  // iconGradientStop props, or with React 18's useId() hook when we update.
  // eslint-disable-next-line @repo/internal/react/disallow-unstable-values
  var id = uid({
    iconGradientStart: iconGradientStop
  });
  if (appearance) {
    colors = getColorsFromAppearance(appearance);
  }
  return "\n    <svg\n      fill=\"none\"\n      height=\"32\"\n      viewBox=\"0 0 32 32\"\n      xmlns=\"http://www.w3.org/2000/svg\"\n    >\n      <linearGradient\n        id=\"".concat(id, "\"\n        gradientUnits=\"userSpaceOnUse\"\n        x1=\"13.9485\"\n        x2=\"20.7792\"\n        y1=\"20.2388\"\n        y2=\"11.8277\"\n      >\n        <stop offset=\"0\" stop-color=\"").concat(colors.iconGradientStart, "\" ").concat(colors.iconGradientStart === 'inherit' ? 'stop-opacity="0.4"' : '', " />\n        <stop offset=\"100%\" stop-color=\"").concat(colors.iconGradientStop, "\" />\n      </linearGradient>\n      <path\n        d=\"m18.3893 7-3.4257 13.1867c4.3592 1.2052 7.8383-.3558 9.1709-5.4802l1.9988-7.6973z\"\n        fill=\"url(#").concat(id, ")\"\n      />\n      <path\n      fill=\"").concat(colors.iconColor, "\"\n      d=\"m13.7566 24.8265 3.4257-13.1866c-4.3623-1.196-7.8383.3649-9.17087 5.4985l-2.01143 7.6881z\"\n      />\n    </svg>");
};

/**
 * __Jira Work Management icon__
 *
 * The Jira Work Management icon without an accompanying wordmark.
 *
 * - [Examples](https://atlassian.design/components/logo/examples)
 * - [Code](https://atlassian.design/components/logo/code)
 * - [Usage](https://atlassian.design/components/logo/usage)
 */
export var JiraWorkManagementIcon = function JiraWorkManagementIcon(_ref2) {
  var appearance = _ref2.appearance,
    _ref2$label = _ref2.label,
    label = _ref2$label === void 0 ? 'Jira Work Management' : _ref2$label,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? defaultLogoParams.size : _ref2$size,
    testId = _ref2.testId,
    _ref2$iconColor = _ref2.iconColor,
    iconColor = _ref2$iconColor === void 0 ? defaultLogoParams.iconColor : _ref2$iconColor,
    _ref2$iconGradientSta = _ref2.iconGradientStart,
    iconGradientStart = _ref2$iconGradientSta === void 0 ? defaultLogoParams.iconGradientStart : _ref2$iconGradientSta,
    _ref2$iconGradientSto = _ref2.iconGradientStop,
    iconGradientStop = _ref2$iconGradientSto === void 0 ? defaultLogoParams.iconGradientStop : _ref2$iconGradientSto,
    _ref2$textColor = _ref2.textColor,
    textColor = _ref2$textColor === void 0 ? defaultLogoParams.textColor : _ref2$textColor;
  return /*#__PURE__*/React.createElement(Wrapper, {
    appearance: appearance,
    label: label,
    svg: svg({
      appearance: appearance,
      iconGradientStart: iconGradientStart,
      iconGradientStop: iconGradientStop,
      iconColor: iconColor
    }),
    iconColor: iconColor,
    iconGradientStart: iconGradientStart,
    iconGradientStop: iconGradientStop,
    size: size,
    testId: testId,
    textColor: textColor
  });
};